package com.eworkcloud.oss;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

import javax.annotation.Resource;

import static com.aliyuncs.auth.sts.AssumeRoleResponse.Credentials;

@Configuration
@ConditionalOnClass(RedisTemplate.class)
@EnableConfigurationProperties(OssClientProperties.class)
public class OssClientConfiguration {

    @Resource
    private OssClientProperties ossClientProperties;
    @Resource
    private RedisTemplate<String, Credentials> redisTemplate;

    @Bean
    public OssClientTemplate ossClientTemplate() {
        return new OssClientTemplate(ossClientProperties, redisTemplate);
    }
}
