package com.eworkcloud.oss;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

@Getter
@Setter
@ConfigurationProperties(prefix = "oss")
public class OssClientProperties {
    /**
     * 访问域名
     */
    private String endpoint;
    /**
     * 访问钥匙
     */
    private String accessKeyId;
    /**
     * 安全密钥
     */
    private String accessKeySecret;
    /**
     * 存储空间
     */
    private String bucketName;
    /**
     * RAM账户
     */
    private Sts sts;

    @Getter
    @Setter
    public static class Sts {
        /**
         * 访问域名
         */
        private String endpoint;
        /**
         * 访问钥匙
         */
        private String accessKeyId;
        /**
         * 安全密钥
         */
        private String accessKeySecret;
        /**
         * 全局资源描述符
         */
        private String roleArn;
        /**
         * 角色会话名称
         */
        private String roleSessionName;
        /**
         * 指定的过期时间，单位为秒。
         * 范围：900 ~ 3600，默认值为3600。
         */
        private long durationSeconds = 3600;
    }
}
