/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectListing;
import com.eworkcloud.oss.OssClientProperties;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import org.apache.commons.io.IOUtils;

public class OssClientTemplate {
    private OssClientProperties ossClientProperties;

    public OssClientTemplate(OssClientProperties ossClientProperties) {
        this.ossClientProperties = ossClientProperties;
    }

    public OSSClient getOSSClient() {
        return new OSSClient(this.ossClientProperties.getEndpoint(), this.ossClientProperties.getAccessKeyId(), this.ossClientProperties.getAccessKeySecret());
    }

    public void createBucket(String bucketName) {
        OSSClient ossClient = this.getOSSClient();
        if (!ossClient.doesBucketExist(bucketName)) {
            ossClient.createBucket(bucketName);
            CreateBucketRequest createBucketRequest = new CreateBucketRequest(bucketName);
            createBucketRequest.setCannedACL(CannedAccessControlList.PublicRead);
            ossClient.createBucket(createBucketRequest);
        }
        ossClient.shutdown();
    }

    public void createBucket() {
        this.createBucket(this.ossClientProperties.getBucketName());
    }

    public byte[] getObject(String bucketName, String key) {
        OSSClient ossClient = null;
        try {
            ossClient = this.getOSSClient();
            OSSObject ossObject = ossClient.getObject(bucketName, key);
            byte[] byArray = IOUtils.toByteArray((InputStream)ossObject.getObjectContent());
            return byArray;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (null != ossClient) {
                ossClient.shutdown();
            }
        }
    }

    public byte[] getObject(String key) {
        return this.getObject(this.ossClientProperties.getBucketName(), key);
    }

    public void putObject(String bucketName, String key, URL url) {
        try {
            this.putObject(bucketName, key, url.openStream());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void putObject(String key, URL url) {
        try {
            this.putObject(key, url.openStream());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void putObject(String bucketName, String key, File file) {
        try {
            this.putObject(bucketName, key, new FileInputStream(file));
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void putObject(String key, File file) {
        try {
            this.putObject(key, new FileInputStream(file));
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void putObject(String bucketName, String key, byte[] input) {
        this.putObject(bucketName, key, new ByteArrayInputStream(input));
    }

    public void putObject(String key, byte[] input) {
        this.putObject(key, new ByteArrayInputStream(input));
    }

    public void putObject(String bucketName, String key, InputStream input) {
        OSSClient ossClient = this.getOSSClient();
        ossClient.putObject(bucketName, key, input);
        ossClient.shutdown();
    }

    public void putObject(String key, InputStream input) {
        this.putObject(this.ossClientProperties.getBucketName(), key, input);
    }

    public void deleteObject(String bucketName, String key) {
        OSSClient ossClient = this.getOSSClient();
        ossClient.deleteObject(bucketName, key);
        ossClient.shutdown();
    }

    public void deleteObject(String key) {
        this.deleteObject(this.ossClientProperties.getBucketName(), key);
    }

    public boolean doesObjectExist(String bucketName, String key) {
        OSSClient ossClient = this.getOSSClient();
        boolean result = ossClient.doesObjectExist(bucketName, key);
        ossClient.shutdown();
        return result;
    }

    public boolean doesObjectExist(String key) {
        return this.doesObjectExist(this.ossClientProperties.getBucketName(), key);
    }

    public ObjectListing listObjects(String bucketName, String prefix) {
        OSSClient ossClient = this.getOSSClient();
        ObjectListing result = ossClient.listObjects(bucketName, prefix);
        ossClient.shutdown();
        return result;
    }

    public ObjectListing listObjects(String prefix) {
        return this.listObjects(this.ossClientProperties.getBucketName(), prefix);
    }

    public URL generatePresignedUrl(String bucketName, String key, Date expiration) {
        OSSClient ossClient = this.getOSSClient();
        URL result = ossClient.generatePresignedUrl(bucketName, key, expiration);
        ossClient.shutdown();
        return result;
    }

    public URL generatePresignedUrl(String bucketName, String key) {
        OSSClient ossClient = this.getOSSClient();
        Date expiration = new Date(new Date().getTime() + 86400000L);
        URL result = ossClient.generatePresignedUrl(bucketName, key, expiration);
        ossClient.shutdown();
        return result;
    }

    public URL generatePresignedUrl(String key, Date expiration) {
        return this.generatePresignedUrl(this.ossClientProperties.getBucketName(), key, expiration);
    }

    public URL generatePresignedUrl(String key) {
        return this.generatePresignedUrl(this.ossClientProperties.getBucketName(), key);
    }
}

