/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.util;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.ObjectListing;
import com.eworkcloud.oss.OssClientTemplate;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import javax.annotation.Resource;

public abstract class OssClientUtils {
    private static OssClientTemplate template;

    @Resource
    public void setTemplate(OssClientTemplate ossClientTemplate) {
        template = ossClientTemplate;
    }

    public static OSSClient getOSSClient() {
        return template.getOSSClient();
    }

    public static void createBucket(String bucketName) {
        template.createBucket(bucketName);
    }

    public static void createBucket() {
        template.createBucket();
    }

    public static byte[] getObject(String bucketName, String key) {
        return template.getObject(bucketName, key);
    }

    public static byte[] getObject(String key) {
        return template.getObject(key);
    }

    public static void putObject(String bucketName, String key, URL url) {
        template.putObject(bucketName, key, url);
    }

    public static void putObject(String key, URL url) {
        template.putObject(key, url);
    }

    public static void putObject(String bucketName, String key, File file) {
        template.putObject(bucketName, key, file);
    }

    public static void putObject(String key, File file) {
        template.putObject(key, file);
    }

    public static void putObject(String bucketName, String key, byte[] input) {
        template.putObject(bucketName, key, input);
    }

    public static void putObject(String key, byte[] input) {
        template.putObject(key, input);
    }

    public static void putObject(String bucketName, String key, InputStream input) {
        template.putObject(bucketName, key, input);
    }

    public static void putObject(String key, InputStream input) {
        template.putObject(key, input);
    }

    public static void deleteObject(String bucketName, String key) {
        template.deleteObject(bucketName, key);
    }

    public static void deleteObject(String key) {
        template.deleteObject(key);
    }

    public static boolean doesObjectExist(String bucketName, String key) {
        return template.doesObjectExist(bucketName, key);
    }

    public static boolean doesObjectExist(String key) {
        return template.doesObjectExist(key);
    }

    public static ObjectListing listObjects(String bucketName, String prefix) {
        return template.listObjects(bucketName, prefix);
    }

    public static ObjectListing listObjects(String prefix) {
        return template.listObjects(prefix);
    }

    public static URL generatePresignedUrl(String bucketName, String key, Date expiration) {
        return template.generatePresignedUrl(bucketName, key, expiration);
    }

    public static URL generatePresignedUrl(String bucketName, String key) {
        return template.generatePresignedUrl(bucketName, key);
    }

    public static URL generatePresignedUrl(String key, Date expiration) {
        return template.generatePresignedUrl(key, expiration);
    }

    public static URL generatePresignedUrl(String key) {
        return template.generatePresignedUrl(key);
    }
}

