package com.eworkcloud.oss;

import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class OssClientConfiguration implements EnvironmentAware {

    private static Environment environment;
    private static String endpoint;
    private static String accessKeyId;
    private static String accessKeySecret;
    private static String bucketName;
    private static String roleArn;
    private static String roleSessionName;
    private static Long durationSeconds;

    @Override
    public void setEnvironment(Environment environment) {
        OssClientConfiguration.environment = environment;
    }

    /**
     * 获取访问域名
     *
     * @return 访问域名
     */
    public static String getEndpoint() {
        if (StringUtils.hasText(endpoint)) {
            return endpoint;
        }
        return environment.getProperty("oss.endpoint");
    }

    /**
     * 设置访问域名
     *
     * @param endpoint 访问域名
     */
    public static void setEndpoint(String endpoint) {
        OssClientConfiguration.endpoint = endpoint;
    }

    /**
     * 获取访问钥匙
     *
     * @return 访问钥匙
     */
    public static String getAccessKeyId() {
        if (StringUtils.hasText(accessKeyId)) {
            return accessKeyId;
        }
        return environment.getProperty("oss.accessKeyId");
    }

    /**
     * 设置访问钥匙
     *
     * @param accessKeyId 访问钥匙
     */
    public static void setAccessKeyId(String accessKeyId) {
        OssClientConfiguration.accessKeyId = accessKeyId;
    }

    /**
     * 获取安全密钥
     *
     * @return 安全密钥
     */
    public static String getAccessKeySecret() {
        if (StringUtils.hasText(accessKeySecret)) {
            return accessKeySecret;
        }
        return environment.getProperty("oss.accessKeySecret");
    }

    /**
     * 设置安全密钥
     *
     * @param accessKeySecret 安全密钥
     */
    public static void setAccessKeySecret(String accessKeySecret) {
        OssClientConfiguration.accessKeySecret = accessKeySecret;
    }

    /**
     * 获取存储空间
     *
     * @return 存储空间
     */
    public static String getBucketName() {
        if (StringUtils.hasText(bucketName)) {
            return bucketName;
        }
        return environment.getProperty("oss.bucketName");
    }

    /**
     * 设置存储空间
     *
     * @param bucketName 存储空间
     */
    public static void setBucketName(String bucketName) {
        OssClientConfiguration.bucketName = bucketName;
    }

    /**
     * 获取全局资源描述符
     *
     * @return 全局资源描述符
     */
    public static String getRoleArn() {
        if (StringUtils.hasText(roleArn)) {
            return roleArn;
        }
        return environment.getProperty("oss.roleArn");
    }

    /**
     * 设置全局资源描述符
     *
     * @param roleArn 全局资源描述符
     */
    public static void setRoleArn(String roleArn) {
        OssClientConfiguration.roleArn = roleArn;
    }

    /**
     * 获取角色会话名称
     *
     * @return 角色会话名称
     */
    public static String getRoleSessionName() {
        if (StringUtils.hasText(roleSessionName)) {
            return roleSessionName;
        }
        return environment.getProperty("oss.roleSessionName");
    }

    /**
     * 设置角色会话名称
     *
     * @param roleSessionName 角色会话名称
     */
    public static void setRoleSessionName(String roleSessionName) {
        OssClientConfiguration.roleSessionName = roleSessionName;
    }

    /**
     * 获取过期时间（秒），范围：900~3600，默认值：3600
     *
     * @return 过期时间（秒）
     */
    public static Long getDurationSeconds() {
        if (null != durationSeconds) {
            return durationSeconds;
        }
        return environment.getProperty("oss.durationSeconds", Long.class, 3600L);
    }

    /**
     * 设置过期时间（秒），范围：900~3600，默认值：3600
     *
     * @param durationSeconds 过期时间（秒）
     */
    public static void setDurationSeconds(long durationSeconds) {
        OssClientConfiguration.durationSeconds = durationSeconds;
    }
}
