/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.util;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectListing;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.auth.sts.AssumeRoleRequest;
import com.aliyuncs.auth.sts.AssumeRoleResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.eworkcloud.oss.OssClientConfiguration;
import com.eworkcloud.oss.model.OssProperties;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;

public abstract class OssClientUtils {
    public static AssumeRoleResponse.Credentials getCredentials(OssProperties properties) {
        try {
            DefaultProfile.addEndpoint((String)"", (String)"Sts", (String)properties.getEndpoint());
            DefaultProfile profile = DefaultProfile.getProfile((String)"", (String)properties.getAccessKeyId(), (String)properties.getAccessKeySecret());
            DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
            AssumeRoleRequest request = new AssumeRoleRequest();
            request.setRoleArn(properties.getRoleArn());
            request.setRoleSessionName(properties.getRoleSessionName());
            request.setDurationSeconds(properties.getDurationSeconds());
            return ((AssumeRoleResponse)acsClient.getAcsResponse((AcsRequest)request)).getCredentials();
        }
        catch (ClientException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static AssumeRoleResponse.Credentials getCredentials() {
        OssProperties properties = new OssProperties();
        properties.setEndpoint(OssClientConfiguration.getEndpoint());
        properties.setAccessKeyId(OssClientConfiguration.getAccessKeyId());
        properties.setAccessKeySecret(OssClientConfiguration.getAccessKeySecret());
        properties.setRoleArn(OssClientConfiguration.getRoleArn());
        properties.setRoleSessionName(OssClientConfiguration.getRoleSessionName());
        properties.setDurationSeconds(OssClientConfiguration.getDurationSeconds());
        return OssClientUtils.getCredentials(properties);
    }

    public static OSSClient getOSSClient(String endpoint, AssumeRoleResponse.Credentials credentials) {
        return new OSSClient(endpoint, credentials.getAccessKeyId(), credentials.getAccessKeySecret(), credentials.getSecurityToken());
    }

    public static OSSClient getOSSClient(AssumeRoleResponse.Credentials credentials) {
        return OssClientUtils.getOSSClient(OssClientConfiguration.getEndpoint(), credentials);
    }

    public static OSSClient getOSSClient(OssProperties properties) {
        return new OSSClient(properties.getEndpoint(), properties.getAccessKeyId(), properties.getAccessKeySecret());
    }

    public static OSSClient getOSSClient() {
        OssProperties properties = new OssProperties();
        properties.setEndpoint(OssClientConfiguration.getEndpoint());
        properties.setAccessKeyId(OssClientConfiguration.getAccessKeyId());
        properties.setAccessKeySecret(OssClientConfiguration.getAccessKeySecret());
        return OssClientUtils.getOSSClient(properties);
    }

    public static void createBucket(OSSClient ossClient, String bucketName) {
        if (!ossClient.doesBucketExist(bucketName)) {
            ossClient.createBucket(bucketName);
            CreateBucketRequest createBucketRequest = new CreateBucketRequest(bucketName);
            createBucketRequest.setCannedACL(CannedAccessControlList.PublicRead);
            ossClient.createBucket(createBucketRequest);
        }
    }

    public static void createBucket(OSSClient ossClient) {
        OssClientUtils.createBucket(ossClient, OssClientConfiguration.getBucketName());
    }

    public static InputStream getObject(OSSClient ossClient, String bucketName, String key) {
        OSSObject ossObject = ossClient.getObject(bucketName, key);
        return ossObject.getObjectContent();
    }

    public static InputStream getObject(OSSClient ossClient, String key) {
        return OssClientUtils.getObject(ossClient, OssClientConfiguration.getBucketName(), key);
    }

    public static void putObject(OSSClient ossClient, String bucketName, String key, URL url) {
        try {
            OssClientUtils.putObject(ossClient, bucketName, key, url.openStream());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void putObject(OSSClient ossClient, String key, URL url) {
        try {
            OssClientUtils.putObject(ossClient, key, url.openStream());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void putObject(OSSClient ossClient, String bucketName, String key, File file) {
        try {
            OssClientUtils.putObject(ossClient, bucketName, key, new FileInputStream(file));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void putObject(OSSClient ossClient, String key, File file) {
        try {
            OssClientUtils.putObject(ossClient, key, new FileInputStream(file));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void putObject(OSSClient ossClient, String bucketName, String key, byte[] input) {
        OssClientUtils.putObject(ossClient, bucketName, key, new ByteArrayInputStream(input));
    }

    public static void putObject(OSSClient ossClient, String key, byte[] input) {
        OssClientUtils.putObject(ossClient, key, new ByteArrayInputStream(input));
    }

    public static void putObject(OSSClient ossClient, String bucketName, String key, InputStream input) {
        ossClient.putObject(bucketName, key, input);
    }

    public static void putObject(OSSClient ossClient, String key, InputStream input) {
        OssClientUtils.putObject(ossClient, OssClientConfiguration.getBucketName(), key, input);
    }

    public static void deleteObject(OSSClient ossClient, String bucketName, String key) {
        ossClient.deleteObject(bucketName, key);
    }

    public static void deleteObject(OSSClient ossClient, String key) {
        OssClientUtils.deleteObject(ossClient, OssClientConfiguration.getBucketName(), key);
    }

    public static boolean doesObjectExist(OSSClient ossClient, String bucketName, String key) {
        return ossClient.doesObjectExist(bucketName, key);
    }

    public static boolean doesObjectExist(OSSClient ossClient, String key) {
        return OssClientUtils.doesObjectExist(ossClient, OssClientConfiguration.getBucketName(), key);
    }

    public static ObjectListing listObjects(OSSClient ossClient, String bucketName, String prefix) {
        return ossClient.listObjects(bucketName, prefix);
    }

    public static ObjectListing listObjects(OSSClient ossClient, String prefix) {
        return OssClientUtils.listObjects(ossClient, OssClientConfiguration.getBucketName(), prefix);
    }

    public static URL generatePresignedUrl(OSSClient ossClient, String bucketName, String key, Date expiration) {
        return ossClient.generatePresignedUrl(bucketName, key, expiration);
    }

    public static URL generatePresignedUrl(OSSClient ossClient, String bucketName, String key) {
        Date expiration = new Date(new Date().getTime() + 86400000L);
        return OssClientUtils.generatePresignedUrl(ossClient, bucketName, key, expiration);
    }

    public static URL generatePresignedUrl(OSSClient ossClient, String key, Date expiration) {
        return OssClientUtils.generatePresignedUrl(ossClient, OssClientConfiguration.getBucketName(), key, expiration);
    }

    public static URL generatePresignedUrl(OSSClient ossClient, String key) {
        return OssClientUtils.generatePresignedUrl(ossClient, OssClientConfiguration.getBucketName(), key);
    }
}

