/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.redis;

import com.eworkcloud.redis.RedisProperties;
import javax.annotation.Resource;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
@EnableCaching
@EnableConfigurationProperties(value={RedisProperties.class})
public class RedisConfiguration {
    @Resource
    private RedisProperties redisProperties;

    @Bean
    public JedisPoolConfig jedisPoolConfig() {
        RedisProperties.Pool pool = this.redisProperties.getPool();
        if (null == pool) {
            pool = new RedisProperties.Pool();
        }
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxTotal(pool.getMaxActive());
        jedisPoolConfig.setMaxIdle(pool.getMaxIdle());
        jedisPoolConfig.setMaxWaitMillis((long)pool.getMaxWait());
        return jedisPoolConfig;
    }

    @Bean
    public JedisConnectionFactory jedisConnectionFactory() {
        JedisConnectionFactory jedisConnectionFactory = new JedisConnectionFactory();
        jedisConnectionFactory.setHostName(this.redisProperties.getHost());
        jedisConnectionFactory.setPort(this.redisProperties.getPort());
        jedisConnectionFactory.setPassword(this.redisProperties.getPassword());
        if (this.redisProperties.getTimeout() > 0) {
            jedisConnectionFactory.setTimeout(this.redisProperties.getTimeout());
        }
        jedisConnectionFactory.setDatabase(this.redisProperties.getDatabase());
        jedisConnectionFactory.setPoolConfig(this.jedisPoolConfig());
        jedisConnectionFactory.setUsePool(true);
        return jedisConnectionFactory;
    }

    @Bean
    public RedisTemplate redisTemplate() {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory((RedisConnectionFactory)this.jedisConnectionFactory());
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        redisTemplate.setKeySerializer((RedisSerializer)stringRedisSerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        GenericJackson2JsonRedisSerializer jackson2RedisSerializer = new GenericJackson2JsonRedisSerializer();
        redisTemplate.setValueSerializer((RedisSerializer)jackson2RedisSerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)jackson2RedisSerializer);
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    @Bean
    public RedisCacheManager redisCacheManager(RedisTemplate redisTemplate) {
        RedisCacheManager redisCacheManager = new RedisCacheManager((RedisOperations)redisTemplate);
        redisCacheManager.setUsePrefix(true);
        return redisCacheManager;
    }
}

