package com.eworkcloud.redis;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

@Getter
@Setter
@ConfigurationProperties(prefix = "redis")
public class RedisProperties {
    /**
     * 主机
     */
    private String host;
    /**
     * 端口（默认：6379）
     */
    private int port = 6379;
    /**
     * 密码
     */
    private String password;
    /**
     * 超时时间（毫秒）
     */
    private int timeout;
    /**
     * 数据库（默认：0）
     */
    private int database = 0;
    /**
     * 过期时间（秒）
     */
    private long expiration = 0;
    /**
     * 连接池
     */
    private Pool pool;

    @Getter
    @Setter
    public static class Pool {
        /**
         * 连接池-最大数量
         */
        private int maxActive = 8;
        /**
         * 连接池-最大Idle
         */
        private int maxIdle = 8;
        /**
         * 连接池-最大等待时间
         */
        private int maxWait = -1;
    }
}
