/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.redis;

import com.eworkcloud.redis.DistributedLock;
import com.eworkcloud.redis.RedisCacheTemplate;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class LockMethodInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LockMethodInterceptor.class);
    private ExpressionParser parser = new SpelExpressionParser();
    private LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();
    private RedisCacheTemplate redisCacheTemplate;

    public LockMethodInterceptor(RedisCacheTemplate redisCacheTemplate) {
        this.redisCacheTemplate = redisCacheTemplate;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        long sleepMills;
        int retryTimes;
        long keepMills;
        Method method = invocation.getMethod();
        DistributedLock annotation = method.getAnnotation(DistributedLock.class);
        Object[] arguments = invocation.getArguments();
        String key = this.parseExpression(annotation.key(), method, arguments);
        boolean lock = this.redisCacheTemplate.lock(key, keepMills = annotation.keepMills(), retryTimes = annotation.retryTimes(), sleepMills = annotation.sleepMills());
        if (!lock) {
            return null;
        }
        try {
            Object object = invocation.proceed();
            return object;
        }
        catch (Exception ex) {
            throw new RuntimeException("Execute distributed lock [" + key + "] method occured an exception", ex);
        }
        finally {
            boolean releaseResult = this.redisCacheTemplate.unlock(key);
            if (!releaseResult) {
                log.warn("Release distributed lock failure: {}", (Object)key);
            }
        }
    }

    private String parseExpression(String key, Method method, Object[] args) {
        String[] parameterNames = this.discoverer.getParameterNames(method);
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int i = 0; i < parameterNames.length; ++i) {
            context.setVariable(parameterNames[i], args[i]);
        }
        return (String)this.parser.parseExpression(key).getValue((EvaluationContext)context, String.class);
    }
}

