/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.redis;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class RedisCacheTemplate {
    private static final Logger log = LoggerFactory.getLogger(RedisCacheTemplate.class);
    private StringRedisTemplate stringRedisTemplate;
    private ObjectMapper objectMapper;
    private static final ThreadLocal<String> THREAD_LOCK = new InheritableThreadLocal<String>();
    private static final String UNLOCK_LUA;

    protected RedisCacheTemplate(StringRedisTemplate stringRedisTemplate, ObjectMapper objectMapper) {
        this.stringRedisTemplate = stringRedisTemplate;
        this.objectMapper = objectMapper;
    }

    private boolean setRedisLock(String key, long keepMills) {
        try {
            RedisCallback callback = connection -> {
                String uuid = UUID.randomUUID().toString();
                THREAD_LOCK.set(uuid);
                return connection.set(key.getBytes(StandardCharsets.UTF_8), uuid.getBytes(StandardCharsets.UTF_8), Expiration.milliseconds((long)keepMills), RedisStringCommands.SetOption.SET_IF_ABSENT);
            };
            return (Boolean)this.stringRedisTemplate.execute(callback);
        }
        catch (Exception ex) {
            log.error("Set redis occured an exception", (Throwable)ex);
            return false;
        }
    }

    public String serialize(Object value) {
        try {
            if (null != value) {
                return this.objectMapper.writeValueAsString(value);
            }
            return null;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T> T deserialize(String value) {
        try {
            if (StringUtils.hasText((String)value)) {
                return (T)this.objectMapper.readValue(value, Object.class);
            }
            return null;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean lock(String key) {
        return this.lock(key, 30000L, Integer.MAX_VALUE, 200L);
    }

    public boolean lock(String key, int retryTimes) {
        return this.lock(key, 30000L, retryTimes, 200L);
    }

    public boolean lock(String key, int retryTimes, long sleepMillis) {
        return this.lock(key, 30000L, retryTimes, sleepMillis);
    }

    public boolean lock(String key, long keepMills) {
        return this.lock(key, keepMills, Integer.MAX_VALUE, 200L);
    }

    public boolean lock(String key, long keepMills, int retryTimes) {
        return this.lock(key, keepMills, retryTimes, 200L);
    }

    public boolean lock(String key, long keepMills, int retryTimes, long sleepMillis) {
        boolean result = this.setRedisLock(key, keepMills);
        while (!result && retryTimes-- > 0) {
            try {
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException ex) {
                return false;
            }
            result = this.setRedisLock(key, keepMills);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlock(String key) {
        try {
            RedisCallback callback = connection -> {
                String uuid = THREAD_LOCK.get();
                return (Boolean)connection.eval(UNLOCK_LUA.getBytes(), ReturnType.BOOLEAN, 1, (byte[][])new byte[][]{key.getBytes(StandardCharsets.UTF_8), uuid.getBytes(StandardCharsets.UTF_8)});
            };
            boolean bl = (Boolean)this.stringRedisTemplate.execute(callback);
            return bl;
        }
        catch (Exception ex) {
            log.error("Release distributed lock occured an exception", (Throwable)ex);
        }
        finally {
            THREAD_LOCK.remove();
        }
        return false;
    }

    public boolean expire(String key, long time) {
        return this.stringRedisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
    }

    public Long getExpire(String key) {
        return this.stringRedisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public boolean hasKey(String key) {
        return this.stringRedisTemplate.hasKey((Object)key);
    }

    public Set<String> keys(String pattern) {
        return this.stringRedisTemplate.keys((Object)pattern);
    }

    public void delete(String ... keys) {
        if (!ObjectUtils.isEmpty((Object[])keys)) {
            if (keys.length == 1) {
                this.stringRedisTemplate.delete((Object)keys[0]);
            } else {
                this.stringRedisTemplate.delete(Arrays.asList(keys));
            }
        }
    }

    public String getString(String key) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)key);
    }

    public <T> T getObject(String key) {
        return this.deserialize(this.getString(key));
    }

    public void setString(String key, String value) {
        this.setString(key, value, 0L);
    }

    public void setString(String key, String value, long time) {
        if (time > 0L) {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value, time, TimeUnit.SECONDS);
        } else {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value);
        }
    }

    public void setObject(String key, Object value) {
        this.setObject(key, value, 0L);
    }

    public void setObject(String key, Object value, long time) {
        this.setString(key, this.serialize(value), time);
    }

    public long increment(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.stringRedisTemplate.opsForValue().increment((Object)key, delta);
    }

    public long decrement(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.stringRedisTemplate.opsForValue().increment((Object)key, -delta);
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("if redis.call(\"get\",KEYS[1]) == ARGV[1] ");
        sb.append("then ");
        sb.append("    return redis.call(\"del\",KEYS[1]) ");
        sb.append("else ");
        sb.append("    return 0 ");
        sb.append("end ");
        UNLOCK_LUA = sb.toString();
    }
}

