package com.eworkcloud.web.util;

import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.eworkcloud.sms.SmsClientConfiguration;
import com.eworkcloud.sms.model.SmsSendMessage;

public abstract class SmsClientUtils {

    /**
     * 获取Acs客户端
     *
     * @return Acs客户端
     */
    public static IAcsClient getAcsClient() {
        IClientProfile profile = DefaultProfile.getProfile(SmsClientConfiguration.getRegionId(),
                SmsClientConfiguration.getAccessKeyId(), SmsClientConfiguration.getAccessKeySecret());
        return new DefaultAcsClient(profile);
    }

    /**
     * 发送短信
     *
     * @param message 短信
     * @return 响应信息
     */
    @SuppressWarnings("deprecation")
    public static CommonResponse send(SmsSendMessage message) {
        IAcsClient acsClient = null;
        try {
            acsClient = getAcsClient();

            // 发送短信请求对象
            CommonRequest request = new CommonRequest();
            request.setProtocol(ProtocolType.HTTPS);
            request.setMethod(MethodType.POST);
            request.setDomain("dysmsapi.aliyuncs.com");
            request.setVersion("2017-05-25");
            request.setAction("SendSms");

            request.putQueryParameter("RegionId", SmsClientConfiguration.getRegionId());
            request.putQueryParameter("PhoneNumbers", message.getMobile());
            request.putQueryParameter("SignName", message.getSignName());
            request.putQueryParameter("TemplateCode", message.getTemplate());
            request.putQueryParameter("TemplateParam", message.getParams());

            return acsClient.getCommonResponse(request);
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        } finally {
            if (null != acsClient) {
                acsClient.shutdown();
            }
        }
    }
}
