/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.util;

import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.eworkcloud.sms.SmsClientConfiguration;
import com.eworkcloud.sms.model.SmsSendMessage;

public abstract class SmsClientUtils {
    public static IAcsClient getAcsClient() {
        DefaultProfile profile = DefaultProfile.getProfile((String)SmsClientConfiguration.getRegionId(), (String)SmsClientConfiguration.getAccessKeyId(), (String)SmsClientConfiguration.getAccessKeySecret());
        return new DefaultAcsClient((IClientProfile)profile);
    }

    public static CommonResponse send(SmsSendMessage message) {
        IAcsClient acsClient = null;
        try {
            acsClient = SmsClientUtils.getAcsClient();
            CommonRequest request = new CommonRequest();
            request.setProtocol(ProtocolType.HTTPS);
            request.setMethod(MethodType.POST);
            request.setDomain("dysmsapi.aliyuncs.com");
            request.setVersion("2017-05-25");
            request.setAction("SendSms");
            request.putQueryParameter("RegionId", SmsClientConfiguration.getRegionId());
            request.putQueryParameter("PhoneNumbers", message.getMobile());
            request.putQueryParameter("SignName", message.getSignName());
            request.putQueryParameter("TemplateCode", message.getTemplate());
            request.putQueryParameter("TemplateParam", message.getParams());
            CommonResponse commonResponse = acsClient.getCommonResponse(request);
            return commonResponse;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (null != acsClient) {
                acsClient.shutdown();
            }
        }
    }
}

