/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web;

import com.eworkcloud.redis.RedisCacheTemplate;
import com.eworkcloud.web.annotation.Authentication;
import com.eworkcloud.web.exception.UnauthorizedException;
import com.eworkcloud.web.model.AccessToken;
import com.eworkcloud.web.util.TokenUtils;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class AuthenticationInterceptor
extends HandlerInterceptorAdapter {
    @Resource
    private RedisCacheTemplate redisCacheTemplate;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        String token = request.getHeader("Authorization");
        if (StringUtils.isNotBlank((CharSequence)token) && token.startsWith("Bearer ")) {
            token = token.substring("Bearer ".length());
        }
        if (StringUtils.isBlank((CharSequence)token)) {
            if (method.isAnnotationPresent(Authentication.class)) {
                throw new UnauthorizedException("Failed to obtain access token for HTTP request with URI: " + request.getServletPath());
            }
            return super.preHandle(request, response, handler);
        }
        AccessToken accessToken = (AccessToken)this.redisCacheTemplate.getObject("oauth:token:" + token);
        if (null == accessToken) {
            if (method.isAnnotationPresent(Authentication.class)) {
                throw new UnauthorizedException("Access token error or expired for HTTP request with URI: " + request.getServletPath());
            }
            return super.preHandle(request, response, handler);
        }
        accessToken.setToken(token);
        TokenUtils.setAccessToken(accessToken);
        if (accessToken.getTtl() > 0) {
            this.redisCacheTemplate.expire("oauth:token:" + token, (long)accessToken.getTtl());
            this.redisCacheTemplate.expire("oauth:token:" + accessToken.getId(), (long)(accessToken.getTtl() + 30));
        } else if (accessToken.getTtl() == 0) {
            this.redisCacheTemplate.expire("oauth:token:" + token, 1800L);
            this.redisCacheTemplate.expire("oauth:token:" + accessToken.getId(), 1830L);
        }
        return super.preHandle(request, response, handler);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        TokenUtils.remove();
    }
}

