/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class QueueExecutorService<T> {
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final BlockingQueue<T> records = new LinkedBlockingQueue<T>();
    private final Runnable command = () -> {
        while (true) {
            Object record;
            if (null == (record = this.records.poll())) {
                continue;
            }
            this.handle(record);
        }
    };
    private volatile boolean started = false;

    public void publish(T record) {
        boolean added;
        boolean bl = added = null == record;
        while (!added) {
            added = this.records.offer(record);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public synchronized void startup() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.executor.execute(this.command);
    }

    public synchronized void shutdown() {
        try {
            this.executor.shutdown();
        }
        finally {
            this.started = false;
        }
    }

    public synchronized void shutdownNow() {
        try {
            this.executor.shutdownNow();
        }
        finally {
            this.started = false;
        }
    }

    protected abstract void handle(T var1);
}

