/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.config;

import com.eworkcloud.web.exception.BusinessException;
import com.eworkcloud.web.exception.PermissionException;
import com.eworkcloud.web.exception.UnauthorizedException;
import com.eworkcloud.web.model.ApiResponse;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={NoHandlerFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public void handle() {
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.METHOD_NOT_ALLOWED)
    public void handle(HttpRequestMethodNotSupportedException ex) {
        log.warn(ex.getMessage());
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public void handle(UnauthorizedException ex) {
        log.warn(ex.getMessage());
    }

    @ExceptionHandler(value={PermissionException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    public void handle(PermissionException ex) {
        log.warn(ex.getMessage());
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ApiResponse handle(HttpMessageNotReadableException ex) {
        String message = "\u53c2\u6570\u7c7b\u578b\u5f02\u5e38\u3002";
        log.error(message, (Throwable)ex);
        return ApiResponse.builder().message(message).details(ex.getMessage()).build();
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ApiResponse handle(MissingServletRequestParameterException ex) {
        String message = "\u7f3a\u5c11\u8bf7\u6c42\u53c2\u6570\u3002";
        log.error(message, (Throwable)ex);
        return ApiResponse.builder().message(message).details(ex.getMessage()).build();
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ApiResponse handle(MethodArgumentNotValidException ex) {
        BindingResult result = ex.getBindingResult();
        FieldError error = result.getFieldError();
        String message = error.getDefaultMessage();
        log.error(message, (Throwable)ex);
        return ApiResponse.builder().message(message).details(ex.getMessage()).build();
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ApiResponse handle(ConstraintViolationException ex) {
        String message = "\u9a8c\u8bc1\u7ea6\u675f\u5f02\u5e38\u3002";
        log.error(message, (Throwable)ex);
        return ApiResponse.builder().message(message).details(ex.getMessage()).build();
    }

    @ExceptionHandler(value={BusinessException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ApiResponse handle(BusinessException ex) {
        String message = ex.getSummary();
        log.error(message, ex.getCause());
        return ApiResponse.builder().message(message).details(ex.getMessage()).build();
    }
}

