/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.model;

import com.eworkcloud.web.enums.ContentType;
import com.eworkcloud.web.enums.HttpMethod;
import java.util.LinkedHashMap;
import java.util.Map;

public class HttpMessage {
    private String url;
    private HttpMethod method;
    private ContentType contentType;
    private Map<String, String> queryMap;
    private Map<String, String> headerMap;
    private Map<String, Object> formData;

    public HttpMessage addQuery(String key, String value) {
        this.queryMap.put(key, value);
        return this;
    }

    public HttpMessage addHeader(String key, String value) {
        this.headerMap.put(key, value);
        return this;
    }

    public HttpMessage addFromData(String key, Object value) {
        this.formData.put(key, value);
        return this;
    }

    private static HttpMethod $default$method() {
        return HttpMethod.GET;
    }

    private static ContentType $default$contentType() {
        return ContentType.JSON;
    }

    private static Map<String, String> $default$queryMap() {
        return new LinkedHashMap<String, String>();
    }

    private static Map<String, String> $default$headerMap() {
        return new LinkedHashMap<String, String>();
    }

    private static Map<String, Object> $default$formData() {
        return new LinkedHashMap<String, Object>();
    }

    public static HttpMessageBuilder builder() {
        return new HttpMessageBuilder();
    }

    public String getUrl() {
        return this.url;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public Map<String, String> getQueryMap() {
        return this.queryMap;
    }

    public Map<String, String> getHeaderMap() {
        return this.headerMap;
    }

    public Map<String, Object> getFormData() {
        return this.formData;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public void setQueryMap(Map<String, String> queryMap) {
        this.queryMap = queryMap;
    }

    public void setHeaderMap(Map<String, String> headerMap) {
        this.headerMap = headerMap;
    }

    public void setFormData(Map<String, Object> formData) {
        this.formData = formData;
    }

    public HttpMessage() {
    }

    public HttpMessage(String url, HttpMethod method, ContentType contentType, Map<String, String> queryMap, Map<String, String> headerMap, Map<String, Object> formData) {
        this.url = url;
        this.method = method;
        this.contentType = contentType;
        this.queryMap = queryMap;
        this.headerMap = headerMap;
        this.formData = formData;
    }

    public static class HttpMessageBuilder {
        private String url;
        private boolean method$set;
        private HttpMethod method;
        private boolean contentType$set;
        private ContentType contentType;
        private boolean queryMap$set;
        private Map<String, String> queryMap;
        private boolean headerMap$set;
        private Map<String, String> headerMap;
        private boolean formData$set;
        private Map<String, Object> formData;

        HttpMessageBuilder() {
        }

        public HttpMessageBuilder url(String url) {
            this.url = url;
            return this;
        }

        public HttpMessageBuilder method(HttpMethod method) {
            this.method = method;
            this.method$set = true;
            return this;
        }

        public HttpMessageBuilder contentType(ContentType contentType) {
            this.contentType = contentType;
            this.contentType$set = true;
            return this;
        }

        public HttpMessageBuilder queryMap(Map<String, String> queryMap) {
            this.queryMap = queryMap;
            this.queryMap$set = true;
            return this;
        }

        public HttpMessageBuilder headerMap(Map<String, String> headerMap) {
            this.headerMap = headerMap;
            this.headerMap$set = true;
            return this;
        }

        public HttpMessageBuilder formData(Map<String, Object> formData) {
            this.formData = formData;
            this.formData$set = true;
            return this;
        }

        public HttpMessage build() {
            HttpMethod method = this.method;
            if (!this.method$set) {
                method = HttpMessage.$default$method();
            }
            ContentType contentType = this.contentType;
            if (!this.contentType$set) {
                contentType = HttpMessage.$default$contentType();
            }
            Map queryMap = this.queryMap;
            if (!this.queryMap$set) {
                queryMap = HttpMessage.$default$queryMap();
            }
            Map headerMap = this.headerMap;
            if (!this.headerMap$set) {
                headerMap = HttpMessage.$default$headerMap();
            }
            Map formData = this.formData;
            if (!this.formData$set) {
                formData = HttpMessage.$default$formData();
            }
            return new HttpMessage(this.url, method, contentType, queryMap, headerMap, formData);
        }

        public String toString() {
            return "HttpMessage.HttpMessageBuilder(url=" + this.url + ", method=" + (Object)((Object)this.method) + ", contentType=" + (Object)((Object)this.contentType) + ", queryMap=" + this.queryMap + ", headerMap=" + this.headerMap + ", formData=" + this.formData + ")";
        }
    }
}

