/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.resolver;

import com.eworkcloud.web.resolver.ResolverHandler;
import com.eworkcloud.web.util.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public abstract class CSVResolver<T>
extends ResolverHandler<T> {
    protected String[] fields;

    public String[] getFields() {
        return this.fields;
    }

    public void setFields(String ... fields) {
        this.fields = fields;
    }

    @Override
    public List<T> resolve(InputStream is) {
        ArrayList<T> entities = new ArrayList<T>();
        InputStreamReader csvReader = null;
        CSVParser csvParser = null;
        try {
            CSVFormat csvFormat = CSVFormat.DEFAULT.withHeader(this.fields).withSkipHeaderRecord();
            csvReader = new InputStreamReader(is, Constants.CHARSET);
            csvParser = new CSVParser((Reader)csvReader, csvFormat);
            List csvRecords = csvParser.getRecords();
            for (CSVRecord record : csvRecords) {
                T entity = this.rowMapper(record);
                if (null == entity) continue;
                entities.add(entity);
            }
            ArrayList<T> arrayList = entities;
            return arrayList;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (null != csvReader) {
                    csvReader.close();
                }
                if (null != csvParser) {
                    csvParser.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected abstract T rowMapper(CSVRecord var1);
}

