/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.util;

import com.eworkcloud.web.exception.BusinessException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class Assert {
    public static boolean isNull(Object object) {
        return null == object;
    }

    public static void isNull(Object object, String message) {
        if (null != object) {
            if (StringUtils.isEmpty((Object)message)) {
                message = "[Assertion failed] - the object argument must be null";
            }
            throw new BusinessException(message);
        }
    }

    public static boolean notNull(Object object) {
        return null != object;
    }

    public static void notNull(Object object, String message) {
        if (null == object) {
            if (StringUtils.isEmpty((Object)message)) {
                message = "[Assertion failed] - this argument is required; it must not be null";
            }
            throw new BusinessException(message);
        }
    }

    public static boolean hasLength(String text) {
        return StringUtils.hasLength((String)text);
    }

    public static void hasLength(String text, String message) {
        if (!StringUtils.hasLength((String)text)) {
            if (StringUtils.isEmpty((Object)message)) {
                message = "[Assertion failed] - this String argument must have length; it must not be null or empty";
            }
            throw new BusinessException(message);
        }
    }

    public static boolean hasText(String text) {
        return StringUtils.hasText((String)text);
    }

    public static void hasText(String text, String message) {
        if (!StringUtils.hasText((String)text)) {
            if (StringUtils.isEmpty((Object)message)) {
                message = "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank";
            }
            throw new BusinessException(message);
        }
    }

    public static boolean isEmpty(Object obj) {
        return ObjectUtils.isEmpty((Object)obj);
    }

    public static boolean notEmpty(Object obj) {
        return !ObjectUtils.isEmpty((Object)obj);
    }

    public static void notEmpty(Object obj, String message) {
        if (ObjectUtils.isEmpty((Object)obj)) {
            if (StringUtils.isEmpty((Object)message)) {
                message = "[Assertion failed] - this object must have value; it must not be null, empty";
            }
            throw new BusinessException(message);
        }
    }

    public static <T> boolean isEmpty(T[] array) {
        return ObjectUtils.isEmpty((Object[])array);
    }

    public static <T> boolean notEmpty(T[] array) {
        return !ObjectUtils.isEmpty((Object[])array);
    }

    public static <T> void notEmpty(T[] array, String message) {
        if (ObjectUtils.isEmpty((Object[])array)) {
            if (StringUtils.isEmpty((Object)message)) {
                message = "[Assertion failed] - this array must not be empty; it must contain at least 1 element";
            }
            throw new BusinessException(message);
        }
    }

    public static <T> boolean isEmpty(Collection<T> collection) {
        return CollectionUtils.isEmpty(collection);
    }

    public static <T> boolean notEmpty(Collection<T> collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static <T> void notEmpty(Collection<T> collection, String message) {
        if (CollectionUtils.isEmpty(collection)) {
            if (StringUtils.isEmpty((Object)message)) {
                message = "[Assertion failed] - this collection must not be empty; it must contain at least 1 element";
            }
            throw new BusinessException(message);
        }
    }

    public static <T> boolean isEmpty(Map<String, T> map) {
        return CollectionUtils.isEmpty(map);
    }

    public static <T> boolean notEmpty(Map<String, T> map) {
        return !CollectionUtils.isEmpty(map);
    }

    public static <T> void notEmpty(Map<String, T> map, String message) {
        if (CollectionUtils.isEmpty(map)) {
            if (StringUtils.isEmpty((Object)message)) {
                message = "[Assertion failed] - this map must not be empty; it must contain at least one entry";
            }
            throw new BusinessException(message);
        }
    }

    public static <T> boolean allEmpty(T bean) {
        if (bean == null) {
            return true;
        }
        Class<?> classz = bean.getClass();
        try {
            Field[] fields;
            for (Field field : fields = classz.getDeclaredFields()) {
                field.setAccessible(true);
                Object value = field.get(bean);
                if (ObjectUtils.isEmpty((Object)value)) continue;
                return false;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return true;
    }

    public static <T> boolean anyEmpty(T bean) {
        if (bean == null) {
            return true;
        }
        Class<?> classz = bean.getClass();
        try {
            Field[] fields;
            for (Field field : fields = classz.getDeclaredFields()) {
                field.setAccessible(true);
                Object value = field.get(bean);
                if (!ObjectUtils.isEmpty((Object)value)) continue;
                return true;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return false;
    }

    public static boolean allEmpty(Object ... objs) {
        if (ObjectUtils.isEmpty((Object[])objs)) {
            return true;
        }
        for (Object obj : objs) {
            if (ObjectUtils.isEmpty((Object)obj)) continue;
            return false;
        }
        return true;
    }

    public static boolean anyEmpty(Object ... objs) {
        if (ObjectUtils.isEmpty((Object[])objs)) {
            return true;
        }
        for (Object obj : objs) {
            if (!ObjectUtils.isEmpty((Object)obj)) continue;
            return true;
        }
        return false;
    }

    public static boolean matcher(String text, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        return matcher.matches();
    }
}

