/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.util;

import com.eworkcloud.web.enums.HmacType;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public abstract class CryptoUtils {
    public static String hmacCrypto(String input, String salt) {
        return CryptoUtils.hmacCrypto(input, salt, HmacType.HmacMD5);
    }

    public static String hmacCrypto(String input, String salt, HmacType type) {
        try {
            byte[] bytes = input.getBytes("UTF-8");
            byte[] value = salt.getBytes("UTF-8");
            SecretKeySpec sks = new SecretKeySpec(value, type.name());
            Mac mac = Mac.getInstance(sks.getAlgorithm());
            mac.init(sks);
            return CryptoUtils.byteToHex(mac.doFinal(bytes));
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String md5Digest(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = input.getBytes("UTF-8");
            return CryptoUtils.byteToHex(md.digest(bytes));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String shaDigest(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] bytes = input.getBytes("UTF-8");
            return CryptoUtils.byteToHex(md.digest(bytes));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String byteToHex(byte[] input) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < input.length; ++i) {
            int val = input[i] & 0xFF;
            if (val < 16) {
                output.append("0");
            }
            output.append(Integer.toHexString(val));
        }
        return output.toString();
    }

    public static byte[] hexToByte(String input) {
        String chars = "0123456789abcdef";
        input = input.toLowerCase();
        int length = input.length() / 2;
        char[] array = input.toCharArray();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)("0123456789abcdef".indexOf(array[i * 2]) << 4 | "0123456789abcdef".indexOf(array[i * 2 + 1]));
        }
        return bytes;
    }
}

