/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public abstract class DateUtils {
    private static final ThreadLocal<DateFormat> dateFormat = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd", Locale.US));
    private static final ThreadLocal<DateFormat> datetimeFormat = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US));
    private static final ThreadLocal<DateFormat> dateEncode = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyyMMdd", Locale.US));
    private static final ThreadLocal<DateFormat> datetimeEncode = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyyMMddHHmmss", Locale.US));

    public static String formatDate(Date date) {
        return dateFormat.get().format(date);
    }

    public static String formatDateTime(Date date) {
        return datetimeFormat.get().format(date);
    }

    public static Date parseDate(String date) {
        try {
            return dateFormat.get().parse(date);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public static Date parseDateTime(String datetime) {
        try {
            return datetimeFormat.get().parse(datetime);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public static String encodeDate(Date date) {
        return dateEncode.get().format(date);
    }

    public static String encodeDateTime(Date date) {
        return datetimeEncode.get().format(date);
    }

    public static Date decodeDate(String date) {
        try {
            return dateEncode.get().parse(date);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public static Date decodeDateTime(String datetime) {
        try {
            return datetimeEncode.get().parse(datetime);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public static Date minTimeOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date maxTimeOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Boolean isExpireDate(Date date) {
        Calendar now = Calendar.getInstance();
        Calendar exp = Calendar.getInstance();
        exp.setTime(date);
        if (now.get(1) != exp.get(1)) {
            return now.get(1) > exp.get(1);
        }
        if (now.get(2) != exp.get(2)) {
            return now.get(2) > exp.get(2);
        }
        return now.get(5) > exp.get(5);
    }

    public static Boolean isExpireTime(Date date) {
        Calendar now = Calendar.getInstance();
        Calendar exp = Calendar.getInstance();
        exp.setTime(date);
        if (now.get(1) != exp.get(1)) {
            return now.get(1) > exp.get(1);
        }
        if (now.get(2) != exp.get(2)) {
            return now.get(2) > exp.get(2);
        }
        if (now.get(5) != exp.get(5)) {
            return now.get(5) > exp.get(5);
        }
        if (now.get(11) != exp.get(11)) {
            return now.get(11) > exp.get(11);
        }
        if (now.get(12) != exp.get(12)) {
            return now.get(12) > exp.get(12);
        }
        return now.get(13) > exp.get(13);
    }

    public LocalDateTime toLocalDateTime(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalDateTime();
    }

    public Date toDate(LocalDateTime localDateTime) {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        return Date.from(zdt.toInstant());
    }
}

