/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.util;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public abstract class HttpUtils {
    public static String doGet(String url, Map<String, String> headers, Map<String, String> params) {
        CloseableHttpClient client = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            HttpEntity httpEntity;
            URIBuilder builder = new URIBuilder(url);
            if (params != null && params.size() > 0) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    builder.addParameter(entry.getKey(), entry.getValue());
                }
            }
            HttpGet httpGet = new HttpGet(builder.build());
            if (headers != null && headers.size() > 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpGet.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((httpEntity = (response = client.execute((HttpUriRequest)httpGet)).getEntity()) != null) {
                String string = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
                return string;
            }
            String string = null;
            return string;
        }
        catch (IOException | URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                client.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] getFile(String url, Map<String, String> headers, Map<String, String> params) {
        CloseableHttpClient client = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            HttpEntity httpEntity;
            URIBuilder builder = new URIBuilder(url);
            if (params != null && params.size() > 0) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    builder.addParameter(entry.getKey(), entry.getValue());
                }
            }
            HttpGet httpGet = new HttpGet(builder.build());
            if (headers != null && headers.size() > 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpGet.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((httpEntity = (response = client.execute((HttpUriRequest)httpGet)).getEntity()) != null) {
                byte[] byArray = EntityUtils.toByteArray((HttpEntity)httpEntity);
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        catch (IOException | URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                client.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String doPost(String url, Map<String, String> headers, Map<String, String> params) {
        CloseableHttpClient client = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            String string;
            HttpPost httpPost = new HttpPost(url);
            if (headers != null && headers.size() > 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                list.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(list, "UTF-8"));
            response = client.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = response.getEntity();
            if (httpEntity != null) {
                string = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
                return string;
            }
            string = null;
            return string;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                client.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String doPost(String url, Map<String, String> headers, String jsonString) {
        CloseableHttpClient client = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            String string;
            HttpPost httpPost = new HttpPost(url);
            if (headers != null && headers.size() > 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            httpPost.setEntity((HttpEntity)new StringEntity(jsonString, ContentType.APPLICATION_JSON));
            response = client.execute((HttpUriRequest)httpPost);
            HttpEntity resEntity = response.getEntity();
            if (resEntity != null) {
                string = EntityUtils.toString((HttpEntity)resEntity, (String)"UTF-8");
                return string;
            }
            string = null;
            return string;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                client.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String postFile(String url, Map<String, String> headers, Map<String, String> params, Map<String, File> files) {
        CloseableHttpClient client = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            if (headers != null && headers.size() > 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                builder.addTextBody(entry.getKey(), entry.getValue(), ContentType.create((String)"text/plain", (String)"UTF-8"));
            }
            for (Map.Entry<String, File> entry : files.entrySet()) {
                builder.addBinaryBody(entry.getKey(), entry.getValue(), ContentType.create((String)"multipart/form-data", (String)"UTF-8"), entry.getValue().getName());
            }
            httpPost.setEntity(builder.build());
            response = client.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = response.getEntity();
            if (httpEntity != null) {
                String string = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
                return string;
            }
            String string = null;
            return string;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                client.close();
            }
            catch (IOException iOException) {}
        }
    }
}

