/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.util;

import com.eworkcloud.web.config.IdWorkerConfiguration;
import com.eworkcloud.web.model.IdDetails;
import java.util.Date;

public abstract class IdWorkerUtils {
    private static final long startTime = 1262275200000L;
    private static final int workerIdBits = 10;
    private static final long maxWorkerId = 1023L;
    private static final int sequenceBits = 12;
    private static final int workerIdShift = 12;
    private static final int timestampShift = 22;
    private static final long sequenceMask = 4095L;
    private static long sequence = 0L;
    private static long lastTimestamp = -1L;

    public static synchronized long nextId() {
        long workerId = IdWorkerConfiguration.workerId;
        if (0L > workerId || workerId > 1023L) {
            throw new RuntimeException(String.format("WorkerId can't be greater than %d or less than 0", 1023L));
        }
        long timestamp = IdWorkerUtils.timeGen();
        if (timestamp < lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards. Refusing to generate id for %d milliseconds", lastTimestamp - timestamp));
        }
        if (lastTimestamp == timestamp) {
            if ((sequence = sequence + 1L & 0xFFFL) == 0L) {
                timestamp = IdWorkerUtils.tillNextMillis(lastTimestamp);
            }
        } else {
            sequence = 0L;
        }
        lastTimestamp = timestamp;
        return timestamp - 1262275200000L << 22 | workerId << 12 | sequence;
    }

    public static IdDetails parseId(long id) {
        return new InternalIdDetails(id);
    }

    private static long tillNextMillis(long lastTimestamp) {
        long timestamp = IdWorkerUtils.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = IdWorkerUtils.timeGen();
        }
        return timestamp;
    }

    private static long timeGen() {
        return System.currentTimeMillis();
    }

    private static class InternalIdDetails
    implements IdDetails {
        private long id;
        private long workerId;
        private Date timestamp;
        private long sequence;

        InternalIdDetails(long id) {
            this.id = id;
            String ids = Long.toBinaryString(id);
            int len = ids.length();
            this.sequence = Long.parseLong(ids.substring(len - 12, len), 2);
            this.workerId = Long.parseLong(ids.substring(len - 22, len - 12), 2);
            this.timestamp = new Date(1262275200000L + (id >> 22));
        }

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        public long getWorkerId() {
            return this.workerId;
        }

        @Override
        public Date getTimestamp() {
            return this.timestamp;
        }

        @Override
        public long getSequence() {
            return this.sequence;
        }
    }
}

