/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.util;

import com.eworkcloud.web.model.HttpMessage;
import com.eworkcloud.web.model.IpDetails;
import com.eworkcloud.web.util.OkHttpUtils;
import javax.servlet.http.HttpServletRequest;

public abstract class IpDetailsUtils {
    private static final String IPINFO = "http://ip.taobao.com/service/getIpInfo.php";
    private static final String USER_AGENT = "Mozilla/5.0 (Windows NT 6.1; WOW64)";

    public static IpDetails getIpInfo(String userAgent, String ip) {
        try {
            IpInfoModel model = OkHttpUtils.execute(HttpMessage.builder().url(IPINFO).build().addHeader("User-Agent", userAgent).addQuery("ip", ip), IpInfoModel.class);
            if (model.getCode() != 0) {
                throw new RuntimeException("Failed to obtain IP information");
            }
            return model.getData();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static IpDetails getIpInfo(HttpServletRequest request, String ip) {
        if (null != request) {
            return IpDetailsUtils.getIpInfo(request.getHeader("User-Agent"), ip);
        }
        return IpDetailsUtils.getIpInfo(USER_AGENT, ip);
    }

    public static IpDetails getIpInfo(String ip) {
        return IpDetailsUtils.getIpInfo(USER_AGENT, ip);
    }

    private static class IpInfoModel {
        private int code = 0;
        private IpDetails data;

        private IpInfoModel() {
        }

        public int getCode() {
            return this.code;
        }

        public IpDetails getData() {
            return this.data;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public void setData(IpDetails data) {
            this.data = data;
        }
    }
}

