/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.io.IOException;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;
import org.springframework.util.StringUtils;

public abstract class JacksonUtils {
    public static final ObjectMapper objectMapper = new ObjectMapper();

    public static String serialize(Object value) {
        try {
            if (null != value) {
                return objectMapper.writeValueAsString(value);
            }
            return null;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static JavaType getJavaType(Class javaType, Class ... classes) {
        return objectMapper.getTypeFactory().constructParametricType(javaType, classes);
    }

    public static <T> T deserialize(String value, Class<T> clazz) {
        try {
            if (!StringUtils.isEmpty((Object)value)) {
                return (T)objectMapper.readValue(value, clazz);
            }
            return null;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T deserialize(String value, JavaType javaType) {
        try {
            if (!StringUtils.isEmpty((Object)value)) {
                return (T)objectMapper.readValue(value, javaType);
            }
            return null;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T deserialize(String value, Class javaType, Class ... classes) {
        try {
            if (!StringUtils.isEmpty((Object)value)) {
                return (T)objectMapper.readValue(value, JacksonUtils.getJavaType(javaType, classes));
            }
            return null;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        SimpleModule longModule = new SimpleModule();
        longModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        longModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
        longModule.addSerializer(BigInteger.class, (JsonSerializer)ToStringSerializer.instance);
        objectMapper.registerModule((Module)longModule);
        JavaTimeModule timeModule = new JavaTimeModule();
        timeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        timeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        timeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        timeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        timeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        timeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        objectMapper.registerModule((Module)timeModule);
    }
}

