/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.util;

import com.eworkcloud.web.enums.ContentType;
import com.eworkcloud.web.enums.HttpMethod;
import com.eworkcloud.web.model.HttpMessage;
import com.eworkcloud.web.util.JacksonUtils;
import com.eworkcloud.web.util.WebUtils;
import com.fasterxml.jackson.databind.JavaType;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public abstract class OkHttpUtils {
    private static final OkHttpClient okHttpClient = new OkHttpClient.Builder().connectionPool(new ConnectionPool(20, 5L, TimeUnit.MINUTES)).connectTimeout(10L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).build();

    private static RequestBody buildRequestBody(HttpMessage message) {
        if (message.getContentType() == ContentType.JSON) {
            MediaType mediaType = MediaType.parse((String)ContentType.JSON.value());
            String bodyString = JacksonUtils.serialize(message.getFormData());
            if (null == bodyString) {
                bodyString = "";
            }
            return RequestBody.create((MediaType)mediaType, (String)bodyString);
        }
        MediaType mediaType = MediaType.parse((String)ContentType.FORM.value());
        String bodyString = WebUtils.mapString(message.getFormData());
        return RequestBody.create((MediaType)mediaType, (String)bodyString);
    }

    private static void attachQuery(Request.Builder builder, HttpMessage message) {
        String url = message.getUrl();
        if (!CollectionUtils.isEmpty(message.getQueryMap())) {
            String queryString = WebUtils.mapString(message.getQueryMap());
            url = String.format("%s%s%s", url, url.contains("?") ? "&" : "?", queryString);
        }
        builder.url(url);
    }

    private static void attachHeader(Request.Builder builder, HttpMessage message) {
        if (!ObjectUtils.isEmpty(message.getHeaderMap())) {
            message.getHeaderMap().forEach((arg_0, arg_1) -> ((Request.Builder)builder).addHeader(arg_0, arg_1));
        }
    }

    private static Request buildRequest(HttpMessage message) {
        Request.Builder builder = new Request.Builder();
        OkHttpUtils.attachQuery(builder, message);
        OkHttpUtils.attachHeader(builder, message);
        if (message.getMethod() == HttpMethod.GET) {
            builder.get();
        } else if (message.getMethod() == HttpMethod.POST) {
            builder.post(OkHttpUtils.buildRequestBody(message));
        } else if (message.getMethod() == HttpMethod.PUT) {
            builder.post(OkHttpUtils.buildRequestBody(message));
        } else if (message.getMethod() == HttpMethod.DELETE) {
            builder.delete();
        } else if (message.getMethod() == HttpMethod.HEAD) {
            builder.head();
        }
        return builder.build();
    }

    public static Response execute(HttpMessage message) {
        try {
            Request request = OkHttpUtils.buildRequest(message);
            return okHttpClient.newCall(request).execute();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T execute(HttpMessage message, Class<T> clazz) {
        try {
            Response response = OkHttpUtils.execute(message);
            if (!response.isSuccessful()) {
                throw new RuntimeException(response.message());
            }
            String bodyString = response.body().string();
            return JacksonUtils.deserialize(bodyString, clazz);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T execute(HttpMessage message, JavaType javaType) {
        try {
            Response response = OkHttpUtils.execute(message);
            if (!response.isSuccessful()) {
                throw new RuntimeException(response.message());
            }
            String bodyString = response.body().string();
            return JacksonUtils.deserialize(bodyString, javaType);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T execute(HttpMessage message, Class javaType, Class ... classes) {
        try {
            Response response = OkHttpUtils.execute(message);
            if (!response.isSuccessful()) {
                throw new RuntimeException(response.message());
            }
            String bodyString = response.body().string();
            return JacksonUtils.deserialize(bodyString, javaType, classes);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void enqueue(HttpMessage message, Callback callback) {
        Request request = OkHttpUtils.buildRequest(message);
        okHttpClient.newCall(request).enqueue(callback);
    }
}

