/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.util;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public abstract class PinyinUtils {
    private static HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();

    public static String getLowerPinyin(String src) {
        if (null == src || src.length() == 0) {
            return src;
        }
        try {
            String words = src.trim();
            StringBuilder output = new StringBuilder();
            for (char word : words.toCharArray()) {
                if (Character.toString(word).matches("[\\u4E00-\\u9FA5]+")) {
                    String[] py = PinyinHelper.toHanyuPinyinStringArray((char)word, (HanyuPinyinOutputFormat)format);
                    output.append(py[0]);
                    continue;
                }
                if (Character.isSpaceChar(word)) continue;
                output.append(Character.isUpperCase(word) ? Character.toLowerCase(word) : word);
            }
            return output.toString();
        }
        catch (BadHanyuPinyinOutputFormatCombination ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getCamelPinyin(String src) {
        if (null == src || src.length() == 0) {
            return src;
        }
        try {
            boolean nextUpper = true;
            String words = src.trim();
            StringBuilder output = new StringBuilder();
            for (char word : words.toCharArray()) {
                if (Character.toString(word).matches("[\\u4E00-\\u9FA5]+")) {
                    String[] py = PinyinHelper.toHanyuPinyinStringArray((char)word, (HanyuPinyinOutputFormat)format);
                    output.append(py[0].substring(0, 1).toUpperCase());
                    output.append(py[0].substring(1));
                    nextUpper = true;
                    continue;
                }
                if (Character.isSpaceChar(word)) {
                    nextUpper = true;
                    continue;
                }
                if (nextUpper) {
                    output.append(Character.toUpperCase(word));
                } else {
                    output.append(Character.toLowerCase(word));
                }
                nextUpper = false;
            }
            return output.toString();
        }
        catch (BadHanyuPinyinOutputFormatCombination ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getCodecPinyin(String src) {
        boolean isFirst = true;
        String words = PinyinUtils.getCamelPinyin(src);
        StringBuilder output = new StringBuilder();
        for (char word : words.toCharArray()) {
            if (Character.isUpperCase(word)) {
                if (!isFirst) {
                    output.append('_');
                } else {
                    isFirst = false;
                }
                output.append(Character.toLowerCase(word));
                continue;
            }
            output.append(word);
        }
        return output.toString();
    }

    public static String getInitialChar(String src) {
        if (null == src || src.length() == 0) {
            return src;
        }
        try {
            String words = src.trim();
            StringBuilder output = new StringBuilder();
            for (char word : words.toCharArray()) {
                if (!Character.toString(word).matches("[\\u4E00-\\u9FA5]+")) continue;
                String[] py = PinyinHelper.toHanyuPinyinStringArray((char)word, (HanyuPinyinOutputFormat)format);
                output.append(py[0].charAt(0));
            }
            return output.toString();
        }
        catch (BadHanyuPinyinOutputFormatCombination ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        format.setVCharType(HanyuPinyinVCharType.WITH_V);
    }
}

