/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.util;

import com.eworkcloud.web.model.HttpMessage;
import com.eworkcloud.web.model.ShortUrl;
import com.eworkcloud.web.util.OkHttpUtils;
import com.eworkcloud.web.util.WebUtils;
import java.util.Collection;
import java.util.List;
import org.springframework.util.CollectionUtils;

public abstract class ShortUrlUtils {
    private static final String SHORTURL = "https://api.weibo.com/2/short_url/shorten.json";

    public static ShortUrl shorten(String appkey, String url) {
        try {
            ShortenModel model = OkHttpUtils.execute(HttpMessage.builder().url(SHORTURL).build().addQuery("source", appkey).addQuery("url_long", WebUtils.urlEncoder(url)), ShortenModel.class);
            if (CollectionUtils.isEmpty((Collection)model.urls)) {
                throw new RuntimeException("Param error, see doc for more info");
            }
            return model.getUrls().get(0);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private static class ShortenModel {
        private List<ShortUrl> urls;

        private ShortenModel() {
        }

        public List<ShortUrl> getUrls() {
            return this.urls;
        }

        public void setUrls(List<ShortUrl> urls) {
            this.urls = urls;
        }
    }
}

