/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.util;

import com.eworkcloud.web.model.TreeNode;
import com.eworkcloud.web.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

public abstract class TreeUtils {
    public static <T extends TreeNode> List<Long> children(List<T> nodes, Collection<Long> ids) {
        LinkedHashSet<Long> nodeSet = new LinkedHashSet<Long>();
        for (Long id : ids) {
            nodeSet.addAll(TreeUtils.children(nodes, id));
        }
        return new ArrayList<Long>(nodeSet);
    }

    public static <T extends TreeNode> List<Long> children(List<T> nodes, Long id) {
        LinkedHashSet<Long> nodeSet = new LinkedHashSet<Long>();
        LinkedHashSet<Long> childs = new LinkedHashSet<Long>();
        for (TreeNode node : nodes) {
            if (!id.equals(node.getPid())) continue;
            childs.add(node.getId());
        }
        if (Assert.notEmpty(childs)) {
            nodeSet.addAll(childs);
            nodeSet.addAll(TreeUtils.children(nodes, childs));
        }
        return new ArrayList<Long>(nodeSet);
    }
}

