/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.util;

import eu.bitwalker.useragentutils.Browser;
import eu.bitwalker.useragentutils.OperatingSystem;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class WebUtils {
    public static String randomString() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String randomNumber(int length) {
        Random random = new Random();
        StringBuilder output = new StringBuilder();
        output.append(random.nextInt(9) + 1);
        for (int i = 0; i < length - 1; ++i) {
            output.append(random.nextInt(10));
        }
        return output.toString();
    }

    public static <T> String mapString(Map<String, T> map) {
        StringBuilder builder = new StringBuilder();
        if (!CollectionUtils.isEmpty(map)) {
            Iterator<Map.Entry<String, T>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, T> entry = it.next();
                if (null == entry.getValue()) continue;
                builder.append(entry.getKey());
                builder.append("=");
                builder.append(entry.getValue());
                if (!it.hasNext()) continue;
                builder.append("&");
            }
        }
        return builder.toString();
    }

    public static <T> String arrayString(Collection<T> list) {
        StringBuilder builder = new StringBuilder();
        if (!CollectionUtils.isEmpty(list)) {
            Iterator<T> it = list.iterator();
            while (it.hasNext()) {
                T entry = it.next();
                if (null == entry) continue;
                builder.append(entry);
                if (!it.hasNext()) continue;
                builder.append(",");
            }
        }
        return builder.toString();
    }

    public static String urlEncoder(String content) {
        try {
            return URLEncoder.encode(content, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String urlDecoder(String content) {
        try {
            return URLDecoder.decode(content, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> void removeDuplicate(Collection<T> list) {
        LinkedHashSet<T> set = new LinkedHashSet<T>(list);
        list.clear();
        list.addAll(set);
    }

    public static HttpServletRequest currentRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (null != requestAttributes) {
            return ((ServletRequestAttributes)requestAttributes).getRequest();
        }
        return null;
    }

    public static HttpServletResponse currentResponse() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (null != requestAttributes) {
            return ((ServletRequestAttributes)requestAttributes).getResponse();
        }
        return null;
    }

    public static String encodeFileName(HttpServletRequest request, String fileName) {
        try {
            String userAgent = request.getHeader("User-Agent").toUpperCase();
            if (userAgent.contains("MSIE") || userAgent.contains("TRIDENT") || userAgent.contains("EDGE")) {
                return URLEncoder.encode(fileName, "utf-8").replace("+", "%20");
            }
            return new String(fileName.getBytes(), "ISO8859-1");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("http_client_ip");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip != null && ip.contains(",")) {
            ip = ip.substring(0, ip.indexOf(",")).trim();
        }
        return ip;
    }

    public static String getSystemName(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        return OperatingSystem.parseUserAgentString((String)userAgent).getName();
    }

    public static String getBrowserInfo(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        Browser browser = Browser.parseUserAgentString((String)userAgent);
        String name = browser.getName();
        String version = browser.getVersion(userAgent).getVersion();
        return String.format("%s %s", name, version);
    }

    public static String getBrowserName(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        return Browser.parseUserAgentString((String)userAgent).getName();
    }

    public static String getBrowserVersion(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        Browser browser = Browser.parseUserAgentString((String)userAgent);
        return browser.getVersion(userAgent).getVersion();
    }
}

