/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.util;

import com.eworkcloud.web.config.WechatConfiguration;
import com.eworkcloud.web.model.HttpMessage;
import com.eworkcloud.web.util.OkHttpUtils;
import com.eworkcloud.web.wechat.WechatStatusInfo;
import com.eworkcloud.web.wechat.WechatTokenInfo;
import com.eworkcloud.web.wechat.WechatUserInfo;

public abstract class WechatUtils {
    private static final String ACCESS_TOKEN = "https://api.weixin.qq.com/sns/oauth2/access_token";
    private static final String REFRESH_TOKEN = "https://api.weixin.qq.com/sns/oauth2/refresh_token";
    private static final String VALIDATE = "https://api.weixin.qq.com/sns/auth";
    private static final String USERINFO = "https://api.weixin.qq.com/sns/userinfo";

    public static WechatTokenInfo accessToken(String code) {
        return OkHttpUtils.execute(HttpMessage.builder().url(ACCESS_TOKEN).build().addQuery("appid", WechatConfiguration.getAppid()).addQuery("secret", WechatConfiguration.getSecret()).addQuery("code", code).addQuery("grant_type", "authorization_code"), WechatTokenInfo.class);
    }

    public static WechatTokenInfo refreshToken(String refreshToken) {
        return OkHttpUtils.execute(HttpMessage.builder().url(REFRESH_TOKEN).build().addQuery("appid", WechatConfiguration.getAppid()).addQuery("grant_type", "REFRESH_TOKEN").addQuery("REFRESH_TOKEN", refreshToken), WechatTokenInfo.class);
    }

    public static WechatStatusInfo validate(String accessToken, String openid) {
        return OkHttpUtils.execute(HttpMessage.builder().url(VALIDATE).build().addQuery("ACCESS_TOKEN", accessToken).addQuery("openid", openid), WechatStatusInfo.class);
    }

    public static WechatUserInfo userinfo(String accessToken, String openid) {
        return OkHttpUtils.execute(HttpMessage.builder().url(USERINFO).build().addQuery("ACCESS_TOKEN", accessToken).addQuery("openid", openid), WechatUserInfo.class);
    }
}

