/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.util;

import com.eworkcloud.web.enums.ContentType;
import com.eworkcloud.web.enums.HttpMethod;
import com.eworkcloud.web.model.HttpMessage;
import com.eworkcloud.web.util.Assert;
import com.eworkcloud.web.util.CryptoUtils;
import com.eworkcloud.web.util.OkHttpUtils;
import com.eworkcloud.web.util.WebUtils;
import com.eworkcloud.webkit.BaiduTranslateConfig;
import com.eworkcloud.webkit.model.Translation;
import java.util.List;

public abstract class BaiduUtils {
    private static final String TRANSLATE = "https://api.fanyi.baidu.com/api/trans/vip/translate";

    public static Translation translate(String text, String from, String to) {
        String appid = BaiduTranslateConfig.getAppid();
        String secret = BaiduTranslateConfig.getSecret();
        String salt = String.valueOf(System.currentTimeMillis());
        String sign = CryptoUtils.md5Digest((String)(appid + text + salt + secret));
        HttpMessage message = HttpMessage.builder().url(TRANSLATE).method(HttpMethod.POST).contentType(ContentType.FORM).build().addFromData("q", (Object)WebUtils.urlEncoder((String)text)).addFromData("from", (Object)from).addFromData("to", (Object)to).addFromData("appid", (Object)appid).addFromData("salt", (Object)salt).addFromData("sign", (Object)sign);
        TransModel model = (TransModel)OkHttpUtils.execute((HttpMessage)message, TransModel.class);
        if (Assert.notNull((Object)model) && Assert.notEmpty(model.getTrans_result())) {
            Translation translation = new Translation();
            translation.setFrom(model.getFrom());
            translation.setTo(model.getTo());
            TransText transText = model.getTrans_result().get(0);
            translation.setSrc(transText.getSrc());
            translation.setDst(transText.getDst());
            return translation;
        }
        throw new RuntimeException("Failure to obtain baidu translation");
    }

    private static class TransText {
        private String src;
        private String dst;

        private TransText() {
        }

        public String getSrc() {
            return this.src;
        }

        public String getDst() {
            return this.dst;
        }

        public void setSrc(String src) {
            this.src = src;
        }

        public void setDst(String dst) {
            this.dst = dst;
        }
    }

    private static class TransModel {
        private String from;
        private String to;
        private List<TransText> trans_result;

        private TransModel() {
        }

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }

        public List<TransText> getTrans_result() {
            return this.trans_result;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public void setTrans_result(List<TransText> trans_result) {
            this.trans_result = trans_result;
        }
    }
}

