/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.util;

import com.eworkcloud.web.enums.ContentType;
import com.eworkcloud.web.enums.HttpMethod;
import com.eworkcloud.web.model.HttpMessage;
import com.eworkcloud.web.util.Assert;
import com.eworkcloud.web.util.OkHttpUtils;
import com.eworkcloud.web.util.WebUtils;
import com.eworkcloud.webkit.GoogleTranslateConfig;
import com.eworkcloud.webkit.model.Translation;
import java.util.List;

public abstract class GoogleUtils {
    private static final String TRANSLATE = "https://translation.googleapis.com/language/translate/v2";

    public static Translation translate(String text, String from, String to) {
        String apiKey = GoogleTranslateConfig.getApiKey();
        HttpMessage message = HttpMessage.builder().url(TRANSLATE).method(HttpMethod.POST).contentType(ContentType.FORM).build().addFromData("q", (Object)WebUtils.urlEncoder((String)text)).addFromData("source", (Object)from).addFromData("target", (Object)to).addFromData("key", (Object)apiKey);
        TransModel model = (TransModel)OkHttpUtils.execute((HttpMessage)message, TransModel.class);
        if (Assert.notNull((Object)model) && Assert.notNull((Object)model.getData()) && Assert.notEmpty(model.getData().getTranslations())) {
            Translation translation = new Translation();
            translation.setFrom(from);
            translation.setTo(to);
            TransText transText = model.getData().getTranslations().get(0);
            translation.setSrc(text);
            translation.setDst(transText.getTranslatedText());
            return translation;
        }
        throw new RuntimeException("Failure to obtain google translation");
    }

    private static class TransText {
        private String translatedText;

        private TransText() {
        }

        public String getTranslatedText() {
            return this.translatedText;
        }

        public void setTranslatedText(String translatedText) {
            this.translatedText = translatedText;
        }
    }

    private static class Translations {
        private List<TransText> translations;

        private Translations() {
        }

        public List<TransText> getTranslations() {
            return this.translations;
        }

        public void setTranslations(List<TransText> translations) {
            this.translations = translations;
        }
    }

    private static class TransModel {
        private Translations data;

        private TransModel() {
        }

        public Translations getData() {
            return this.data;
        }

        public void setData(Translations data) {
            this.data = data;
        }
    }
}

