/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.util;

import com.eworkcloud.web.enums.HttpMethod;
import com.eworkcloud.web.exception.BusinessException;
import com.eworkcloud.web.model.HttpMessage;
import com.eworkcloud.web.util.Assert;
import com.eworkcloud.web.util.Base64Utils;
import com.eworkcloud.web.util.Constants;
import com.eworkcloud.web.util.CryptoUtils;
import com.eworkcloud.web.util.OkHttpUtils;
import com.eworkcloud.web.util.OrikaUtils;
import com.eworkcloud.web.util.WebUtils;
import com.eworkcloud.webkit.WxworkConfiguration;
import com.eworkcloud.webkit.model.ByteArray;
import com.eworkcloud.webkit.util.PKCS7Padding;
import com.eworkcloud.webkit.wxwork.WxworkMessage;
import com.eworkcloud.webkit.wxwork.WxworkSendStatus;
import com.eworkcloud.webkit.wxwork.WxworkTokenInfo;
import java.io.StringReader;
import java.security.Key;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class WxworkUtils {
    private static final String TOKEN = "https://qyapi.weixin.qq.com/cgi-bin/gettoken";
    private static final String SEND = "https://qyapi.weixin.qq.com/cgi-bin/message/send";

    private static String encrypt(String text) {
        if (WxworkConfiguration.getAesKey().length() != 43) {
            throw new BusinessException("AesKey\u975e\u6cd5");
        }
        byte[] aesKey = Base64Utils.decodeToBytes((String)(WxworkConfiguration.getAesKey() + "="));
        byte[] textBytes = text.getBytes(Constants.CHARSET);
        ByteArray byteArray = new ByteArray();
        byteArray.addValue(WebUtils.randomString((int)16));
        byteArray.addValue(CryptoUtils.intToBytes((int)textBytes.length));
        byteArray.addValue(textBytes);
        byteArray.addValue(WxworkConfiguration.getCorpid());
        byteArray.addValue(PKCS7Padding.encode(byteArray.size()));
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(aesKey, 0, 16);
            cipher.init(1, (Key)keySpec, iv);
            return Base64Utils.encodeToString((byte[])cipher.doFinal(byteArray.toBytes()));
        }
        catch (Exception ex) {
            throw new BusinessException("AES\u52a0\u5bc6\u5931\u8d25", (Throwable)ex);
        }
    }

    private static String decrypt(String text) {
        String corpid;
        String xmlContent;
        byte[] original;
        if (WxworkConfiguration.getAesKey().length() != 43) {
            throw new BusinessException("AesKey\u975e\u6cd5");
        }
        byte[] aesKey = Base64Utils.decodeToBytes((String)(WxworkConfiguration.getAesKey() + "="));
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(aesKey, 0, 16);
            cipher.init(2, (Key)keySpec, iv);
            original = cipher.doFinal(Base64Utils.decodeToBytes((String)text));
        }
        catch (Exception ex) {
            throw new BusinessException("AES\u89e3\u5bc6\u5931\u8d25", (Throwable)ex);
        }
        try {
            byte[] bytes = PKCS7Padding.decode(original);
            int xmlLength = CryptoUtils.bytesToInt((byte[])Arrays.copyOfRange(bytes, 16, 20));
            xmlContent = new String(Arrays.copyOfRange(bytes, 20, 20 + xmlLength), Constants.CHARSET);
            corpid = new String(Arrays.copyOfRange(bytes, 20 + xmlLength, bytes.length), Constants.CHARSET);
        }
        catch (Exception ex) {
            throw new BusinessException("\u89e3\u5bc6\u6570\u636e\u5f02\u5e38", (Throwable)ex);
        }
        if (!corpid.equals(WxworkConfiguration.getCorpid())) {
            throw new BusinessException("CorpID\u975e\u6cd5");
        }
        return xmlContent;
    }

    private static String extract(String text) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            StringReader sr = new StringReader(text);
            InputSource is = new InputSource(sr);
            Document document = db.parse(is);
            Element root = document.getDocumentElement();
            NodeList encrypt = root.getElementsByTagName("Encrypt");
            return encrypt.item(0).getTextContent();
        }
        catch (Exception ex) {
            throw new BusinessException("XML\u89e3\u6790\u5931\u8d25", (Throwable)ex);
        }
    }

    private static String generate(String encrypt, String signature, String timestamp, String nonce) {
        String format = "<xml>\n<Encrypt><![CDATA[%1$s]]></Encrypt>\n<MsgSignature><![CDATA[%2$s]]></MsgSignature>\n<TimeStamp>%3$s</TimeStamp>\n<Nonce><![CDATA[%4$s]]></Nonce>\n</xml>";
        return String.format(format, encrypt, signature, timestamp, nonce);
    }

    private static String signature(String timestamp, String nonce, String echostr) {
        try {
            Object[] array = new String[]{WxworkConfiguration.getToken(), timestamp, nonce, echostr};
            Arrays.sort(array);
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < 4; ++i) {
                builder.append((String)array[i]);
            }
            return CryptoUtils.shaDigest((String)builder.toString());
        }
        catch (Exception ex) {
            throw new BusinessException("SHA\u7b7e\u540d\u5931\u8d25", (Throwable)ex);
        }
    }

    public static WxworkTokenInfo getToken(String secret) {
        return (WxworkTokenInfo)OkHttpUtils.execute((HttpMessage)HttpMessage.builder().url(TOKEN).build().addQuery("corpid", WxworkConfiguration.getCorpid()).addQuery("corpsecret", secret), WxworkTokenInfo.class);
    }

    public static WxworkTokenInfo getToken() {
        return WxworkUtils.getToken(WxworkConfiguration.getSecret());
    }

    public static WxworkSendStatus send(String accessToken, Map<String, Object> formData) {
        if (!formData.containsKey("agentid") || Assert.isEmpty((Object)formData.get("agentid"))) {
            formData.put("agentid", WxworkConfiguration.getAgentid());
        }
        return (WxworkSendStatus)OkHttpUtils.execute((HttpMessage)HttpMessage.builder().url(SEND).method(HttpMethod.POST).formData(formData).build().addQuery("access_token", accessToken), WxworkSendStatus.class);
    }

    public static WxworkSendStatus send(String accessToken, WxworkMessage message) {
        return WxworkUtils.send(accessToken, OrikaUtils.beanToMap((Object)message));
    }

    public static String encrypt(String message, String timestamp, String nonce) {
        String encrypt = WxworkUtils.encrypt(message);
        String signature = WxworkUtils.signature(timestamp, nonce, encrypt);
        return WxworkUtils.generate(encrypt, signature, timestamp, nonce);
    }

    public static String decrypt(String signature, String timestamp, String nonce, String postData) {
        String echostr = WxworkUtils.extract(postData);
        String validate = WxworkUtils.signature(timestamp, nonce, echostr);
        if (!validate.equals(signature)) {
            throw new BusinessException("\u7b7e\u540d\u9a8c\u8bc1\u9519\u8bef");
        }
        return WxworkUtils.decrypt(echostr);
    }

    public static String verify(String signature, String timestamp, String nonce, String echostr) {
        String validate = WxworkUtils.signature(timestamp, nonce, echostr);
        if (!validate.equals(signature)) {
            throw new BusinessException("\u7b7e\u540d\u9a8c\u8bc1\u9519\u8bef");
        }
        return WxworkUtils.decrypt(echostr);
    }
}

