package com.eworkcloud.web.config;

import com.eworkcloud.web.util.Assert;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class WxworkConfiguration implements EnvironmentAware {

    private static Environment environment;
    private static String corpid;
    private static Integer agentid;
    private static String secret;
    private static String token;
    private static String aesKey;

    @Override
    public void setEnvironment(Environment environment) {
        WxworkConfiguration.environment = environment;
    }

    /**
     * 获取企业ID
     *
     * @return 企业ID
     */
    public static String getCorpid() {
        if (Assert.hasText(corpid)) {
            return corpid;
        }
        return environment.getProperty("wxwork.corpid");
    }

    /**
     * 设置企业ID
     *
     * @param corpid 企业ID
     */
    public static void setCorpid(String corpid) {
        WxworkConfiguration.corpid = corpid;
    }

    /**
     * 获取应用ID
     *
     * @return 应用ID
     */
    public static Integer getAgentid() {
        if (Assert.notNull(agentid)) {
            return agentid;
        }
        return environment.getProperty("wxwork.agentid", Integer.class);
    }

    /**
     * 设置应用ID
     *
     * @param agentid 应用ID
     */
    public static void setAgentid(Integer agentid) {
        WxworkConfiguration.agentid = agentid;
    }

    /**
     * 获取应用密钥
     *
     * @return 应用密钥
     */
    public static String getSecret() {
        if (Assert.hasText(secret)) {
            return secret;
        }
        return environment.getProperty("wxwork.secret");
    }

    /**
     * 设置应用密钥
     *
     * @param secret 应用密钥
     */
    public static void setSecret(String secret) {
        WxworkConfiguration.secret = secret;
    }

    /**
     * 获取回调令牌
     *
     * @return 回调令牌
     */
    public static String getToken() {
        if (Assert.hasText(token)) {
            return token;
        }
        return environment.getProperty("wxwork.token");
    }

    /**
     * 设置回调令牌
     *
     * @param token 回调令牌
     */
    public static void setToken(String token) {
        WxworkConfiguration.token = token;
    }

    /**
     * 获取AES密钥
     *
     * @return AES密钥
     */
    public static String getAesKey() {
        if (Assert.hasText(aesKey)) {
            return aesKey;
        }
        return environment.getProperty("wxwork.aesKey");
    }

    /**
     * 设置AES密钥
     *
     * @param aesKey AES密钥
     */
    public static void setAesKey(String aesKey) {
        WxworkConfiguration.aesKey = aesKey;
    }
}
