package com.eworkcloud.web.util;

import com.eworkcloud.web.config.WechatConfiguration;
import com.eworkcloud.web.model.HttpMessage;
import com.eworkcloud.web.wechat.WechatStatusInfo;
import com.eworkcloud.web.wechat.WechatTokenInfo;
import com.eworkcloud.web.wechat.WechatUserInfo;

public abstract class WechatUtils {
    /**
     * 通过code获取access_token
     * ?appid=APPID&secret=SECRET&code=CODE&grant_type=authorization_code
     */
    private static final String ACCESS_TOKEN = "https://api.weixin.qq.com/sns/oauth2/access_token";
    /**
     * 刷新或续期access_token
     * ?appid=APPID&grant_type=REFRESH_TOKEN&REFRESH_TOKEN=REFRESH_TOKEN
     */
    private static final String REFRESH_TOKEN = "https://api.weixin.qq.com/sns/oauth2/refresh_token";
    /**
     * 检验access_token是否有效
     * ?ACCESS_TOKEN=ACCESS_TOKEN&openid=OPENID
     */
    private static final String VALIDATE = "https://api.weixin.qq.com/sns/auth";
    /**
     * 获取用户信息（UnionID机制）
     * ?ACCESS_TOKEN=ACCESS_TOKEN&openid=OPENID
     */
    private static final String USERINFO = "https://api.weixin.qq.com/sns/userinfo";

    /**
     * 通过code获取access_token
     *
     * @param code CODE
     * @return 访问令牌
     */
    public static WechatTokenInfo accessToken(String code) {
        return OkHttpUtils.execute(HttpMessage.builder()
                .url(ACCESS_TOKEN)
                .build()
                .addQuery("appid", WechatConfiguration.getAppid())
                .addQuery("secret", WechatConfiguration.getSecret())
                .addQuery("code", code)
                .addQuery("grant_type", "authorization_code"), WechatTokenInfo.class);
    }

    /**
     * 刷新或续期access_token
     *
     * @param refreshToken 刷新令牌
     * @return 访问令牌
     */
    public static WechatTokenInfo refreshToken(String refreshToken) {
        return OkHttpUtils.execute(HttpMessage.builder()
                .url(REFRESH_TOKEN)
                .build()
                .addQuery("appid", WechatConfiguration.getAppid())
                .addQuery("grant_type", "REFRESH_TOKEN")
                .addQuery("REFRESH_TOKEN", refreshToken), WechatTokenInfo.class);
    }

    /**
     * 检验access_token是否有效
     *
     * @param accessToken 访问令牌
     * @param openid      OPENID
     * @return 是否有效
     */
    public static WechatStatusInfo validate(String accessToken, String openid) {
        return OkHttpUtils.execute(HttpMessage.builder()
                .url(VALIDATE)
                .build()
                .addQuery("ACCESS_TOKEN", accessToken)
                .addQuery("openid", openid), WechatStatusInfo.class);
    }

    /**
     * 获取用户信息（UnionID机制）
     *
     * @param accessToken 访问令牌
     * @param openid      OPENID
     * @return 用户信息
     */
    public static WechatUserInfo getUserInfo(String accessToken, String openid) {
        return OkHttpUtils.execute(HttpMessage.builder()
                .url(USERINFO)
                .build()
                .addQuery("ACCESS_TOKEN", accessToken)
                .addQuery("openid", openid), WechatUserInfo.class);
    }
}
