package com.eworkcloud.web.wechat;

import lombok.Getter;
import lombok.Setter;

import java.util.List;

@Getter
@Setter
public class WechatUserInfo extends WechatStatusInfo {
    /**
     * OPENID
     */
    private String openid;
    /**
     * 昵称
     */
    private String nickname;
    /**
     * 性别，1为男性，2为女性
     */
    private Byte sex;
    /**
     * 语言
     */
    private String language;
    /**
     * 省份
     */
    private String province;
    /**
     * 城市
     */
    private String city;
    /**
     * 国家，如中国为CN
     */
    private String country;
    /**
     * 头像，最后一个数值代表正方形头像大小（有0、46、64、96、132数值可选，0代表640*640正方形头像）
     */
    private String headimgurl;
    /**
     * 特权，如微信沃卡用户为（chinaunicom）
     */
    private List<String> privilege;
    /**
     * UNIONID
     */
    private String unionid;
}
