package com.eworkcloud.web.config;

import com.eworkcloud.web.util.Assert;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class BaiduTranslateConfig implements EnvironmentAware {

    private static Environment environment;
    private static String appid;
    private static String secret;

    @Override
    public void setEnvironment(Environment environment) {
        BaiduTranslateConfig.environment = environment;
    }

    /**
     * 获取应用ID
     *
     * @return 应用ID
     */
    public static String getAppid() {
        if (Assert.hasText(appid)) {
            return appid;
        }
        return environment.getProperty("baidu.appid");
    }

    /**
     * 设置应用ID
     *
     * @param appid 应用ID
     */
    public static void setAppid(String appid) {
        BaiduTranslateConfig.appid = appid;
    }

    /**
     * 获取应用密钥
     *
     * @return 应用密钥
     */
    public static String getSecret() {
        if (Assert.hasText(secret)) {
            return secret;
        }
        return environment.getProperty("baidu.secret");
    }

    /**
     * 设置应用密钥
     *
     * @param secret 应用密钥
     */
    public static void setSecret(String secret) {
        BaiduTranslateConfig.secret = secret;
    }
}
