package com.eworkcloud.web.config;

import com.eworkcloud.web.util.Assert;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class GoogleTranslateConfig implements EnvironmentAware {

    private static Environment environment;
    private static String apiKey;

    @Override
    public void setEnvironment(Environment environment) {
        GoogleTranslateConfig.environment = environment;
    }

    /**
     * 获取应用密钥
     *
     * @return 应用密钥
     */
    public static String getApiKey() {
        if (Assert.hasText(apiKey)) {
            return apiKey;
        }
        return environment.getProperty("google.apiKey");
    }

    /**
     * 设置应用密钥
     *
     * @param apiKey 应用密钥
     */
    public static void setApiKey(String apiKey) {
        GoogleTranslateConfig.apiKey = apiKey;
    }
}
