package com.eworkcloud.web.util;

import com.eworkcloud.web.config.GoogleTranslateConfig;
import com.eworkcloud.web.enums.ContentType;
import com.eworkcloud.web.enums.HttpMethod;
import com.eworkcloud.web.model.Translation;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

public abstract class GoogleUtils {

    private static final String TRANSLATE = "https://translation.googleapis.com/language/translate/v2";

    @Getter
    @Setter
    private static class TransModel {
        /**
         * 翻译结果
         */
        private Translations data;
    }

    @Getter
    @Setter
    private static class Translations {
        /**
         * 翻译列表
         */
        private List<TransText> translations;
    }

    @Getter
    @Setter
    private static class TransText {
        /**
         * 译文
         */
        private String translatedText;
    }

    /**
     * 翻译单个文本
     *
     * @param text 文本
     * @param from 源语言
     * @param to   目标语言
     * @return 翻译结果
     */
    public static Translation translate(String text, String from, String to) {
        String apiKey = GoogleTranslateConfig.getApiKey();

        OkHttpParam param = OkHttpParam.builder()
                .url(TRANSLATE)
                .method(HttpMethod.POST)
                .contentType(ContentType.FORM)
                .build();

        param.addFromData("q", WebUtils.urlEncoder(text));
        if (Assert.hasText(from)) {
            param.addFromData("source", from);
        }
        param.addFromData("target", to);
        param.addFromData("key", apiKey);

        TransModel model = OkHttpUtils.execute(param, TransModel.class);
        if (Assert.notNull(model) && Assert.notNull(model.getData()) &&
                Assert.notEmpty(model.getData().getTranslations())) {
            Translation translation = new Translation();
            translation.setFrom(from);
            translation.setTo(to);
            TransText transText = model.getData().getTranslations().get(0);
            translation.setSrc(text);
            translation.setDst(transText.getTranslatedText());
            return translation;
        } else {
            throw new RuntimeException("Failure to obtain google translation");
        }
    }

    /**
     * 翻译单个文本
     *
     * @param text 文本
     * @param to   目标语言
     * @return 翻译结果
     */
    public static Translation translate(String text, String to) {
        return translate(text, null, to);
    }
}
