package com.eworkcloud.web.config;

import com.eworkcloud.web.util.Assert;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class WechatConfiguration implements EnvironmentAware {

    private static Environment environment;
    private static String appid;
    private static String secret;

    @Override
    public void setEnvironment(Environment environment) {
        WechatConfiguration.environment = environment;
    }

    /**
     * 获取应用ID
     *
     * @return 应用ID
     */
    public static String getAppid() {
        if (Assert.hasText(appid)) {
            return appid;
        }
        return environment.getProperty("wechat.appid");
    }

    /**
     * 设置应用ID
     *
     * @param appid 应用ID
     */
    public static void setAppid(String appid) {
        WechatConfiguration.appid = appid;
    }

    /**
     * 获取应用密钥
     *
     * @return 应用密钥
     */
    public static String getSecret() {
        if (Assert.hasText(secret)) {
            return secret;
        }
        return environment.getProperty("wechat.secret");
    }

    /**
     * 设置应用密钥
     *
     * @param secret 应用密钥
     */
    public static void setSecret(String secret) {
        WechatConfiguration.secret = secret;
    }
}
