package com.eworkcloud.web.model;

import java.util.ArrayList;

import static com.eworkcloud.web.util.Constants.CHARSET;

/**
 * 字节数组类
 *
 * @author 马恩全
 */
public final class ByteArray {

    private ArrayList<Byte> container = new ArrayList<>();

    /**
     * 获取字节数组
     *
     * @return 字节数组
     */
    public byte[] toBytes() {
        byte[] bytes = new byte[container.size()];
        for (int i = 0; i < container.size(); i++) {
            bytes[i] = container.get(i);
        }
        return bytes;
    }

    /**
     * 添加字节数组
     *
     * @param value 字节数组
     * @return 字节数组类
     */
    public ByteArray addValue(byte[] value) {
        for (byte v : value) {
            container.add(v);
        }
        return this;
    }

    /**
     * 添加字节数组
     *
     * @param value 字符串
     * @return 字节数组类
     */
    public ByteArray addValue(String value) {
        if (null != value) {
            addValue(value.getBytes(CHARSET));
        }
        return this;
    }

    /**
     * 获取数组大小
     *
     * @return 数组大小
     */
    public int size() {
        return container.size();
    }
}
