package com.eworkcloud.web.util;

import java.util.Arrays;

/**
 * PKCS7算法工具
 *
 * @author 马恩全
 */
public abstract class PKCS7Padding {

    private static final byte BLOCK_SIZE = 32;

    /**
     * 获得补位填充的字节数组
     *
     * @param count 需要填充补位的字节个数
     * @return 补位填充的字节数组
     */
    public static byte[] encode(int count) {
        // 计算需要填充的位数
        byte padding = (byte) (BLOCK_SIZE - (count % BLOCK_SIZE));

        byte[] bytes = new byte[padding];
        for (int i = 0; i < padding; i++) {
            bytes[i] = padding;
        }
        return bytes;
    }

    /**
     * 删除解密后明文的补位字符
     *
     * @param bytes 解密后的明文
     * @return 删除补位字符后的明文
     */
    public static byte[] decode(byte[] bytes) {
        byte padding = bytes[bytes.length - 1];
        if (padding < 1 || padding > BLOCK_SIZE) {
            padding = 0;
        }
        return Arrays.copyOfRange(bytes, 0, bytes.length - padding);
    }
}
