package com.eworkcloud.web.wxwork;

import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
public abstract class WxworkMessage {
    /**
     * 成员ID列表，多个接收者用‘|’分隔，最多支持1000个
     * 特殊情况：指定为@all，则向该企业应用的全部成员发送
     */
    private String touser;
    /**
     * 部门ID列表，多个接收者用‘|’分隔，最多支持100个
     * 当touser为@all时忽略本参数
     */
    private String toparty;
    /**
     * 标签ID列表，多个接收者用‘|’分隔，最多支持100个
     * 当touser为@all时忽略本参数
     */
    private String totag;
    /**
     * 消息类型（text|image|voice|video|file|textcard|news|mpnews|markdown|taskcard）
     */
    private String msgtype;
    /**
     * 应用的ID
     */
    private Integer agentid;
}
