/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.exasoltestsetup;

import com.exasol.bucketfs.Bucket;
import com.exasol.exasoltestsetup.SqlConnectionInfo;
import java.net.InetSocketAddress;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;

public interface ExasolTestSetup
extends AutoCloseable {
    public Connection createConnection() throws SQLException;

    public SqlConnectionInfo getConnectionInfo();

    public Bucket getDefaultBucket();

    public InetSocketAddress makeLocalTcpServiceAccessibleFromDatabase(int var1);

    public List<Integer> makeDatabaseTcpServiceAccessibleFromLocalhost(int var1);

    default public InetSocketAddress makeTcpServiceAccessibleFromDatabase(InetSocketAddress serviceAddress) {
        boolean isLocalAddress = Set.of("localhost", "127.0.0.1").contains(serviceAddress.getHostName());
        if (isLocalAddress) {
            return this.makeLocalTcpServiceAccessibleFromDatabase(serviceAddress.getPort());
        }
        return serviceAddress;
    }
}

