/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.exasoltestsetup;

import com.exasol.errorreporting.ExaError;
import com.exasol.exasoltestsetup.ExasolTestSetup;
import com.exasol.exasoltestsetup.standalone.JsonConnectionDetailsReader;
import com.exasol.exasoltestsetup.standalone.StandaloneExasolTestSetup;
import com.exasol.exasoltestsetup.testcontainers.ExasolTestcontainerTestSetup;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExasolTestSetupFactory {
    private static final Logger LOGGER = Logger.getLogger(ExasolTestSetupFactory.class.getName());
    private final Path standaloneConfigurationPath;
    private final DispatchMode dispatchMode;

    public ExasolTestSetupFactory(Path standaloneConfigurationPath) {
        this(standaloneConfigurationPath, DispatchMode.AUTO);
    }

    public ExasolTestSetupFactory() {
        this(null, DispatchMode.CONTAINER);
    }

    public ExasolTestSetupFactory(Path standaloneConfigurationPath, DispatchMode dispatchMode) {
        if (dispatchMode == DispatchMode.STANDALONE) {
            if (standaloneConfigurationPath == null) {
                throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-ETAJ-37").message("The configuration file parameter must not be NULL for a for a standalone test setup does not exist.", new Object[0]).mitigation("Create the configuration file and make sure the path is provided.", new Object[0]).mitigation("Pick a dispatch mode that does not depend on this file (either CONTAINER or AUTO)", new Object[0]).toString());
            }
            throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-ETAJ-38").message("The configuration file {{file}} required for a for a standalone test setup does not exist.", new Object[0]).parameter("file", (Object)standaloneConfigurationPath.toString(), "path to the configuration file").mitigation("Create the configuration file and make sure the path is correct.", new Object[0]).mitigation("Pick a dispatch mode that does not depend on this file (either CONTAINER or AUTO)", new Object[0]).toString());
        }
        this.standaloneConfigurationPath = standaloneConfigurationPath;
        this.dispatchMode = dispatchMode;
    }

    public ExasolTestSetup getTestSetup() {
        switch (this.dispatchMode) {
            case CONTAINER: {
                LOGGER.info(() -> "Using Exasol test container setup (forced container mode)");
                return new ExasolTestcontainerTestSetup();
            }
            case STANDALONE: {
                LOGGER.info(() -> "Using Exasol standalone test setup (forced standalone mode)");
                return new ExasolTestcontainerTestSetup();
            }
            case AUTO: {
                if (Files.exists(this.standaloneConfigurationPath, new LinkOption[0])) {
                    LOGGER.info(() -> "Using Exasol standalone test setup (auto mode with configuration file present)");
                    return new StandaloneExasolTestSetup(new JsonConnectionDetailsReader().read(this.standaloneConfigurationPath));
                }
                LOGGER.log(Level.INFO, "Using Exasol test container setup (auto mode with configuration file {0} missing)", this.standaloneConfigurationPath);
                return new ExasolTestcontainerTestSetup();
            }
        }
        throw new IllegalArgumentException("Unknown Dispatcher Mode '" + this.dispatchMode + "' trying to create test setup");
    }

    public boolean hasStandaloneConfigurationPath() {
        return this.standaloneConfigurationPath != null;
    }

    public static enum DispatchMode {
        AUTO,
        CONTAINER,
        STANDALONE;

    }
}

