/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.exasoltestsetup;

import com.exasol.exasoltestsetup.identity.IdentityProvider;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class SessionBuilder {
    private String user;
    private String host;
    private int port;
    private IdentityProvider identityProvider;
    private final Map<String, String> config = new HashMap<String, String>();

    public SessionBuilder identity(IdentityProvider value) {
        this.identityProvider = value;
        return this;
    }

    public SessionBuilder user(String value) {
        this.user = value;
        return this;
    }

    public SessionBuilder host(String value) {
        this.host = value;
        return this;
    }

    public SessionBuilder port(int value) {
        this.port = value;
        return this;
    }

    public SessionBuilder config(String key, String value) {
        this.config.put(key, value);
        return this;
    }

    public Session build() throws JSchException {
        JSch jsch = new JSch();
        this.identityProvider.addIdentityTo(jsch);
        Session session = jsch.getSession(this.user, this.host, this.port);
        session.setConfig(new Hashtable<String, String>(this.config));
        return session;
    }

    public String getUser() {
        return this.user;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

