/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.exasoltestsetup;

import com.exasol.errorreporting.ExaError;
import com.exasol.exasoltestsetup.SessionBuilder;
import com.exasol.exasoltestsetup.SshExecution;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.net.ServerSocket;

public class SshConnection
implements AutoCloseable {
    private static final String PORT_FINDER_PYTHON_SCRIPT = "import socket\nfrom contextlib import closing\nwith closing(socket.socket(socket.AF_INET, socket.SOCK_STREAM)) as s:\n    s.bind(('', 0))\n    s.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)\n    print(s.getsockname()[1])\n\n";
    private final Session sshSession;

    public SshConnection(SessionBuilder sessionBuilder) {
        this.sshSession = this.createSession(sessionBuilder);
    }

    private Session createSession(SessionBuilder sessionBuilder) {
        Session session;
        try {
            session = sessionBuilder.build();
            session.setConfig("StrictHostKeyChecking", "no");
            session.connect();
        }
        catch (JSchException exception) {
            if (exception.getMessage().startsWith("invalid privatekey")) {
                throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETAJ-13").message("The format of your privatekey is not supported.", new Object[0]).mitigation("Convert using `ssh-keygen -p -f id_rsa -m pem -P \"\" -N \"\"\n`", new Object[0]).toString(), exception);
            }
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETAJ-12").message("Failed to ssh to the exasol database. This is required for redirecting a host port.", new Object[0]).mitigation("Make sure the database is reachable, i.e. port {{port}} open on host {{host}}.", new Object[]{sessionBuilder.getPort(), sessionBuilder.getHost()}).mitigation("Make sure user {{user}} can login to the database using your ssh-key.", new Object[]{sessionBuilder.getUser()}).toString(), exception);
        }
        return session;
    }

    public int addReversePortForwarding(int localPort) {
        int remotePort = this.findFreePortOnServer();
        try {
            this.sshSession.setPortForwardingR("*", remotePort, "localhost", localPort);
            return remotePort;
        }
        catch (JSchException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETAJ-22").message("Failed to setup reverse port forwarding.", new Object[0]).toString(), exception);
        }
    }

    public int addForwardPortForwarding(int remotePort) {
        return this.addForwardPortForwarding(remotePort, "localhost");
    }

    public int addForwardPortForwarding(int remotePort, String targetHost) {
        int localPort = this.findFreeLocalPort();
        try {
            this.sshSession.setPortForwardingL("localhost", localPort, targetHost, remotePort);
            return localPort;
        }
        catch (JSchException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETAJ-24").message("Failed to setup forward port forwarding.", new Object[0]).toString(), exception);
        }
    }

    public SshExecution runCommandAsRoot(String command) {
        return this.runCommand("echo \"" + command.replace("\"", "\\\"") + "\" | sudo sh");
    }

    public SshExecution runCommand(String command) {
        return new SshExecution(this.sshSession, command);
    }

    public int findFreePortOnServer() {
        String portOutput = this.runCommand("python <<HEREDOC\nimport socket\nfrom contextlib import closing\nwith closing(socket.socket(socket.AF_INET, socket.SOCK_STREAM)) as s:\n    s.bind(('', 0))\n    s.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)\n    print(s.getsockname()[1])\n\nHEREDOC").whenFinished().assertExitCodeIsZero().getStdout();
        try {
            return Integer.parseInt(portOutput.trim());
        }
        catch (NumberFormatException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"F-ETAJ-29").message("Failed to find free port on server. The python script had an invalid output: {{output}}.", new Object[]{portOutput}).ticketMitigation().toString(), exception);
        }
    }

    private int findFreeLocalPort() {
        int n;
        ServerSocket socket = new ServerSocket(0);
        try {
            n = socket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                throw new IllegalStateException(ExaError.messageBuilder((String)"F-ETAJ-23").message("Failed to search for a free local port.", new Object[0]).ticketMitigation().toString(), exception);
            }
        }
        socket.close();
        return n;
    }

    @Override
    public void close() {
        this.sshSession.disconnect();
    }
}

