/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.exasoltestsetup;

import com.exasol.errorreporting.ExaError;
import com.exasol.exasoltestsetup.SshExecutionResult;
import com.exasol.exasoltestsetup.WaitHelper;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class SshExecution {
    private final Channel channel;
    private final String command;
    private final InputStream stdErrStream;
    private final InputStream stdOutStream;

    SshExecution(Session session, String command) {
        this.command = command;
        try {
            this.channel = session.openChannel("exec");
            ((ChannelExec)this.channel).setCommand(command);
            this.channel.setInputStream(null);
            this.stdErrStream = ((ChannelExec)this.channel).getErrStream();
            this.stdOutStream = this.channel.getInputStream();
            this.channel.connect();
        }
        catch (JSchException | IOException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETAJ-20").message("Failed to run command via ssh.", new Object[0]).toString(), exception);
        }
    }

    private SshExecutionResult readAllOutputAndWaitForExit(String command, Channel channel, InputStream stdErrStream, InputStream stdOutStream) {
        try {
            StringBuilder stdout = new StringBuilder();
            while (channel.isClosed()) {
                stdout.append(new String(stdOutStream.readAllBytes(), StandardCharsets.UTF_8));
                WaitHelper.waitFor(100L);
            }
            stdout.append(new String(stdOutStream.readAllBytes(), StandardCharsets.UTF_8));
            return new SshExecutionResult(stdout.toString(), new String(stdErrStream.readAllBytes(), StandardCharsets.UTF_8), channel.getExitStatus(), command);
        }
        catch (IOException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETAJ-26").message("Failed to read output of ssh command {{command}}.", new Object[]{command}).toString(), exception);
        }
    }

    public SshExecutionResult whenFinished() {
        SshExecutionResult result = this.readAllOutputAndWaitForExit(this.command, this.channel, this.stdErrStream, this.stdOutStream);
        this.channel.disconnect();
        return result;
    }
}

