/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.exasoltestsetup;

import com.exasol.errorreporting.ExaError;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SshExecutionResult {
    private static final Logger LOGGER = Logger.getLogger(SshExecutionResult.class.getName());
    private final String stdout;
    private final String stderr;
    private final int exitCode;
    private final String command;

    SshExecutionResult(String stdout, String stderr, int exitCode, String command) {
        this.stdout = stdout;
        this.stderr = stderr;
        this.exitCode = exitCode;
        this.command = command;
    }

    public String getStdout() {
        return this.stdout;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public SshExecutionResult assertExitCodeIsZero() {
        if (this.exitCode != 0) {
            LOGGER.log(Level.SEVERE, this.stderr);
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETAJ-19").message("Failed to run command {{command}} in database cluster. The command had a return code != 0.", new Object[]{this.command}).mitigation("See log output above.", new Object[0]).toString());
        }
        return this;
    }
}

