/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.exasoltestsetup;

import com.exasol.errorreporting.ExaError;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;

public class WaitHelper {
    private WaitHelper() {
    }

    public static void waitFor(long milliSeconds) {
        try {
            Thread.sleep(milliSeconds);
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
        }
    }

    public static void waitUntil(BooleanSupplier predicate, int timeoutAfterSec, String jobDescription) {
        long start = System.currentTimeMillis();
        while (!predicate.getAsBoolean()) {
            long elapsed = System.currentTimeMillis() - start;
            if (TimeUnit.MILLISECONDS.toSeconds(elapsed) > (long)timeoutAfterSec) {
                throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETAJ-31").message("Timeout waiting for {{jobDescription|uq}}.", new Object[]{jobDescription}).toString());
            }
            WaitHelper.waitFor(200L);
        }
    }
}

